/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.greedyensemble;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.DWOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased.FastABOD;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.KNNOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.KNNWeightOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.LocalIsolationCoefficient;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.ODIN;
import de.lmu.ifi.dbs.elki.algorithm.outlier.intrinsic.IDOS;
import de.lmu.ifi.dbs.elki.algorithm.outlier.intrinsic.IntrinsicDimensionalityOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.COF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.INFLO;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.KDEOS;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LDF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LDOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LoOP;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.SimpleKernelDensityLOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.SimplifiedLOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.VarianceOfVolume;
import de.lmu.ifi.dbs.elki.algorithm.outlier.trivial.ByLabelOutlier;
import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.PreprocessorKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.PolynomialKernelFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.HillEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.GaussianKernelDensityFunction;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.IdentityScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Locale;
import java.util.regex.Pattern;

@Reference(authors="E. Schubert, R. Wojdanowski, A. Zimek, H.-P. Kriegel", title="On Evaluation of Outlier Rankings and Outlier Scores", booktitle="Proc. 12th SIAM International Conference on Data Mining (SDM), Anaheim, CA, 2012.")
public class ComputeKNNOutlierScores<O extends NumberVector>
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(ComputeKNNOutlierScores.class);
    final InputStep inputstep;
    final DistanceFunction<? super O> distf;
    final int startk;
    final int stepk;
    final int maxk;
    File outfile;
    ByLabelOutlier bylabel;
    ScalingFunction scaling;
    Pattern disable = null;

    public ComputeKNNOutlierScores(InputStep inputStep, DistanceFunction<? super O> distanceFunction, int n, int n2, int n3, ByLabelOutlier byLabelOutlier, File file, ScalingFunction scalingFunction, Pattern pattern) {
        this.distf = distanceFunction;
        this.startk = n;
        this.stepk = n2;
        this.maxk = n3;
        this.inputstep = inputStep;
        this.bylabel = byLabelOutlier;
        this.outfile = file;
        this.scaling = scalingFunction;
        this.disable = pattern;
    }

    @Override
    public void run() {
        int n;
        PrintStream printStream;
        Object object;
        int n2;
        int n3;
        final Database database = this.inputstep.getDatabase();
        final Relation relation = database.getRelation(this.distf.getInputTypeRestriction(), new Object[0]);
        KNNQuery<O> kNNQuery = QueryUtil.getKNNQuery(relation, this.distf, n3 = Math.min((n2 = Math.min(this.maxk, relation.size() - 1)) + 2, relation.size()));
        if (!(kNNQuery instanceof PreprocessorKNNQuery)) {
            object = new MaterializeKNNPreprocessor<O>(relation, this.distf, n3);
            ((AbstractMaterializeKNNPreprocessor)object).initialize();
            relation.getHierarchy().add(relation, (Result)object);
        }
        if (!((kNNQuery = QueryUtil.getKNNQuery(relation, this.distf, n3)) instanceof PreprocessorKNNQuery)) {
            throw new AbortException("Not using preprocessor knn query -- KNN queries using class: " + kNNQuery.getClass());
        }
        object = relation.getDBIDs();
        try {
            printStream = new PrintStream(this.outfile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AbortException("Cannot create output file.", fileNotFoundException);
        }
        printStream.append("# Data set size: " + relation.size());
        printStream.append(" data type: " + relation.getDataTypeInformation());
        printStream.append(FormatUtil.NEWLINE);
        OutlierResult outlierResult = this.bylabel.run(database);
        this.writeResult(printStream, (DBIDs)object, outlierResult, new IdentityScaling(), "bylabel");
        int n4 = this.startk > 0 ? this.startk : this.stepk;
        int n5 = n = n4 >= 2 ? n4 : n4 + this.stepk;
        final int n6 = n4 >= 3 ? n4 : (n >= 3 ? n : n + this.stepk);
        this.runForEachK("KNN", n4, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                KNNOutlier kNNOutlier = new KNNOutlier(ComputeKNNOutlierScores.this.distf, n);
                OutlierResult outlierResult = kNNOutlier.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("KNNW", n4, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                KNNWeightOutlier kNNWeightOutlier = new KNNWeightOutlier(ComputeKNNOutlierScores.this.distf, n);
                OutlierResult outlierResult = kNNWeightOutlier.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("LOF", n4, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                LOF lOF = new LOF(n, ComputeKNNOutlierScores.this.distf);
                OutlierResult outlierResult = lOF.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("SimplifiedLOF", n4, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                SimplifiedLOF simplifiedLOF = new SimplifiedLOF(n, ComputeKNNOutlierScores.this.distf);
                OutlierResult outlierResult = simplifiedLOF.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("LoOP", n4, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                LoOP loOP = new LoOP(n, n, ComputeKNNOutlierScores.this.distf, ComputeKNNOutlierScores.this.distf, 1.0);
                OutlierResult outlierResult = loOP.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("LDOF", n, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n3, String string) {
                if (n3 == n && n2 > 100) {
                    LOG.verbose("Note: LODF needs O(k^2) distance computations. Use -" + Parameterizer.DISABLE_ID.getName() + " LDOF to disable.");
                }
                LDOF lDOF = new LDOF(ComputeKNNOutlierScores.this.distf, n3);
                OutlierResult outlierResult = lDOF.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("ODIN", n4, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                ODIN oDIN = new ODIN(ComputeKNNOutlierScores.this.distf, n);
                OutlierResult outlierResult = oDIN.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("FastABOD", n6, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                if (n == n6 && n2 > 100) {
                    LOG.verbose("Note: FastABOD needs quadratic memory. Use -" + Parameterizer.DISABLE_ID.getName() + " FastABOD to disable.");
                }
                FastABOD<NumberVector> fastABOD = new FastABOD<NumberVector>(new PolynomialKernelFunction(2), n);
                OutlierResult outlierResult = fastABOD.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("KDEOS", n, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                KDEOS kDEOS = new KDEOS(ComputeKNNOutlierScores.this.distf, n, n, GaussianKernelDensityFunction.KERNEL, 0.0, 0.5 * GaussianKernelDensityFunction.KERNEL.canonicalBandwidth(), 2);
                OutlierResult outlierResult = kDEOS.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("LDF", n4, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                LDF lDF = new LDF(n, ComputeKNNOutlierScores.this.distf, GaussianKernelDensityFunction.KERNEL, 1.0, 0.1);
                OutlierResult outlierResult = lDF.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("INFLO", n4, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                INFLO iNFLO = new INFLO(ComputeKNNOutlierScores.this.distf, 1.0, n);
                OutlierResult outlierResult = iNFLO.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("COF", n4, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                COF cOF = new COF(n, ComputeKNNOutlierScores.this.distf);
                OutlierResult outlierResult = cOF.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("Intrinsic", n, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                IntrinsicDimensionalityOutlier intrinsicDimensionalityOutlier = new IntrinsicDimensionalityOutlier(ComputeKNNOutlierScores.this.distf, n, HillEstimator.STATIC);
                OutlierResult outlierResult = intrinsicDimensionalityOutlier.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("IDOS", n, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                IDOS iDOS = new IDOS(ComputeKNNOutlierScores.this.distf, HillEstimator.STATIC, n, n);
                OutlierResult outlierResult = iDOS.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("KDLOF", n, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                SimpleKernelDensityLOF simpleKernelDensityLOF = new SimpleKernelDensityLOF(n, ComputeKNNOutlierScores.this.distf, GaussianKernelDensityFunction.KERNEL);
                OutlierResult outlierResult = simpleKernelDensityLOF.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("DWOF", n, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n3, String string) {
                if (n3 == n && n2 > 100) {
                    LOG.verbose("Note: DWOF needs O(k^2) distance computations. Use -" + Parameterizer.DISABLE_ID.getName() + " DWOF to disable.");
                }
                DWOF dWOF = new DWOF(ComputeKNNOutlierScores.this.distf, n3, 1.1);
                OutlierResult outlierResult = dWOF.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        this.runForEachK("LIC", n4, this.stepk, n2, new AlgRunner((DBIDs)object){
            final /* synthetic */ DBIDs val$ids;
            {
                this.val$ids = dBIDs;
            }

            @Override
            public void run(int n, String string) {
                LocalIsolationCoefficient localIsolationCoefficient = new LocalIsolationCoefficient(ComputeKNNOutlierScores.this.distf, n);
                OutlierResult outlierResult = localIsolationCoefficient.run(database, relation);
                ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                database.getHierarchy().removeSubtree(outlierResult);
            }
        });
        if (TypeUtil.DOUBLE_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
            final DistanceFunction<? super O> distanceFunction = this.distf;
            final Relation relation2 = relation;
            this.runForEachK("VOV", n4, this.stepk, n2, new AlgRunner((DBIDs)object){
                final /* synthetic */ DBIDs val$ids;
                {
                    this.val$ids = dBIDs;
                }

                @Override
                public void run(int n, String string) {
                    VarianceOfVolume varianceOfVolume = new VarianceOfVolume(n, distanceFunction);
                    OutlierResult outlierResult = varianceOfVolume.run(database, relation2);
                    ComputeKNNOutlierScores.this.writeResult(printStream, this.val$ids, outlierResult, ComputeKNNOutlierScores.this.scaling, string);
                    database.getHierarchy().removeSubtree(outlierResult);
                }
            });
        }
    }

    void writeResult(PrintStream printStream, DBIDs dBIDs, OutlierResult outlierResult, ScalingFunction scalingFunction, String string) {
        if (scalingFunction instanceof OutlierScalingFunction) {
            ((OutlierScalingFunction)scalingFunction).prepare(outlierResult);
        }
        printStream.append(string);
        DoubleRelation doubleRelation = outlierResult.getScores();
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d = doubleRelation.doubleValue(dBIDIter);
            if (scalingFunction != null) {
                d = scalingFunction.getScaled(d);
            }
            printStream.append(' ').append(Double.toString(d));
            dBIDIter.advance();
        }
        printStream.append(FormatUtil.NEWLINE);
    }

    private void runForEachK(String string, int n, int n2, int n3, AlgRunner algRunner) {
        if (this.isDisabled(string)) {
            LOG.verbose("Skipping (disabled): " + string);
            return;
        }
        LOG.verbose("Running " + string);
        int n4 = (int)Math.ceil(Math.log10(n3 + 1));
        String string2 = "%s-%0" + n4 + "d";
        for (int i = n; i <= n3; i += n2) {
            Duration duration = LOG.newDuration(this.getClass().getCanonicalName() + "." + string + ".k" + i + ".runtime").begin();
            algRunner.run(i, String.format(Locale.ROOT, string2, string, i));
            LOG.statistics(duration.end());
        }
    }

    protected boolean isDisabled(String string) {
        return this.disable != null && this.disable.matcher(string).matches();
    }

    public static void main(String[] stringArray) {
        ComputeKNNOutlierScores.runCLIApplication(ComputeKNNOutlierScores.class, stringArray);
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractApplication.Parameterizer {
        public static final OptionID STEPK_ID = new OptionID("stepk", "Step size for k.");
        public static final OptionID STARTK_ID = new OptionID("startk", "Minimum value for k.");
        public static final OptionID MAXK_ID = new OptionID("maxk", "Maximum value for k.");
        public static final OptionID SCALING_ID = new OptionID("scaling", "Scaling function.");
        public static final OptionID DISABLE_ID = new OptionID("disable", "Disable methods (regular expression, case insensitive, anchored).");
        int stepk;
        int startk;
        int maxk;
        InputStep inputstep;
        DistanceFunction<? super O> distf;
        ByLabelOutlier bylabel;
        ScalingFunction scaling = null;
        File outfile;
        Pattern disable = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            PatternParameter patternParameter;
            IntParameter intParameter;
            super.makeOptions(parameterization);
            this.inputstep = parameterization.tryInstantiate(InputStep.class);
            ObjectParameter objectParameter = AbstractAlgorithm.makeParameterDistanceFunction(EuclideanDistanceFunction.class, DistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distf = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(STEPK_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.stepk = (Integer)intParameter.getValue();
            }
            IntParameter intParameter2 = new IntParameter(STARTK_ID);
            intParameter2.setOptional(true);
            this.startk = parameterization.grab(intParameter2) ? (Integer)intParameter2.getValue() : this.stepk;
            IntParameter intParameter3 = (IntParameter)new IntParameter(MAXK_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter3)) {
                this.maxk = (Integer)intParameter3.getValue();
            }
            this.bylabel = parameterization.tryInstantiate(ByLabelOutlier.class);
            this.outfile = super.getParameterOutputFile(parameterization, "File to output the resulting score vectors to.");
            ObjectParameter objectParameter2 = new ObjectParameter(SCALING_ID, ScalingFunction.class);
            objectParameter2.setOptional(true);
            if (parameterization.grab(objectParameter2)) {
                this.scaling = (ScalingFunction)objectParameter2.instantiateClass(parameterization);
            }
            if (parameterization.grab(patternParameter = (PatternParameter)new PatternParameter(DISABLE_ID).setOptional(true))) {
                this.disable = (Pattern)patternParameter.getValue();
            }
        }

        @Override
        protected ComputeKNNOutlierScores<O> makeInstance() {
            return new ComputeKNNOutlierScores<O>(this.inputstep, this.distf, this.startk, this.stepk, this.maxk, this.bylabel, this.outfile, this.scaling, this.disable);
        }
    }

    private static interface AlgRunner {
        public void run(int var1, String var2);
    }
}

