/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.AbstractNumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FloatVector
extends AbstractNumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<FloatVector> BYTE_SERIALIZER = new SmallSerializer();
    public static final ByteBufferSerializer<FloatVector> SHORT_SERIALIZER = new ShortSerializer();
    public static final ByteBufferSerializer<FloatVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final float[] values;

    private FloatVector(float[] fArray, boolean bl) {
        this.values = bl ? fArray : (float[])fArray.clone();
    }

    public FloatVector(float[] fArray) {
        this.values = (float[])fArray.clone();
    }

    public FloatVector(Vector vector) {
        double[] dArray = vector.getArrayRef();
        this.values = new float[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.values[i] = (float)dArray[i];
        }
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    @Deprecated
    public Float getValue(int n) {
        return Float.valueOf(this.values[n]);
    }

    @Override
    public double doubleValue(int n) {
        return this.values[n];
    }

    @Override
    public long longValue(int n) {
        return (long)this.values[n];
    }

    @Override
    public Vector getColumnVector() {
        return new Vector(ArrayLikeUtil.toPrimitiveDoubleArray(this.values, ArrayLikeUtil.FLOATARRAYADAPTER));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            stringBuilder.append(this.values[i]);
            if (i + 1 >= this.values.length) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<FloatVector> {
        @Override
        public FloatVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            assert (byteBuffer.remaining() >= 4 * n);
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = byteBuffer.getFloat();
            }
            return new FloatVector(fArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, FloatVector floatVector) throws IOException {
            assert (floatVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (byteBuffer.remaining() >= 4 * floatVector.values.length);
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, floatVector.values.length);
            for (int i = 0; i < floatVector.values.length; ++i) {
                byteBuffer.putFloat(floatVector.values[i]);
            }
        }

        @Override
        public int getByteSize(FloatVector floatVector) {
            assert (floatVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return ByteArrayUtil.getUnsignedVarintSize(floatVector.values.length) + 4 * floatVector.values.length;
        }
    }

    public static class ShortSerializer
    implements ByteBufferSerializer<FloatVector> {
        @Override
        public FloatVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.getShort();
            assert (byteBuffer.remaining() >= 4 * n);
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = byteBuffer.getFloat();
            }
            return new FloatVector(fArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, FloatVector floatVector) throws IOException {
            assert (floatVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            assert (byteBuffer.remaining() >= 4 * floatVector.values.length);
            byteBuffer.putShort((short)floatVector.values.length);
            for (int i = 0; i < floatVector.values.length; ++i) {
                byteBuffer.putFloat(floatVector.values[i]);
            }
        }

        @Override
        public int getByteSize(FloatVector floatVector) {
            assert (floatVector.values.length < Short.MAX_VALUE) : "This serializer only supports a maximum dimensionality of 32767!";
            return 2 + 4 * floatVector.getDimensionality();
        }
    }

    public static class SmallSerializer
    implements ByteBufferSerializer<FloatVector> {
        @Override
        public FloatVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = byteBuffer.get();
            assert (byteBuffer.remaining() >= 4 * n);
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = byteBuffer.getFloat();
            }
            return new FloatVector(fArray, true);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, FloatVector floatVector) throws IOException {
            assert (floatVector.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            assert (byteBuffer.remaining() >= 4 * floatVector.values.length);
            byteBuffer.put((byte)floatVector.values.length);
            for (int i = 0; i < floatVector.values.length; ++i) {
                byteBuffer.putFloat(floatVector.values[i]);
            }
        }

        @Override
        public int getByteSize(FloatVector floatVector) {
            assert (floatVector.values.length < 127) : "This serializer only supports a maximum dimensionality of 127!";
            return 1 + 4 * floatVector.getDimensionality();
        }
    }

    public static class Factory
    extends AbstractNumberVector.Factory<FloatVector> {
        @Override
        public <A> FloatVector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            int n = arrayAdapter.size(a);
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = arrayAdapter.get(a, i).floatValue();
            }
            return new FloatVector(fArray, true);
        }

        @Override
        public <A> FloatVector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            int n = numberArrayAdapter.size(a);
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = numberArrayAdapter.getFloat(a, i);
            }
            return new FloatVector(fArray, true);
        }

        @Override
        public ByteBufferSerializer<FloatVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super FloatVector> getRestrictionClass() {
            return FloatVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

