/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.AbstractNumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class OneDimensionalDoubleVector
extends AbstractNumberVector {
    public static final Factory STATIC = new Factory();
    double val;

    public OneDimensionalDoubleVector(double d) {
        this.val = d;
    }

    @Override
    public int getDimensionality() {
        return 1;
    }

    @Override
    public double doubleValue(int n) {
        assert (n == 0) : "Non-existant dimension accessed.";
        return this.val;
    }

    @Override
    public long longValue(int n) {
        assert (n == 0) : "Non-existant dimension accessed.";
        return (long)this.val;
    }

    @Override
    @Deprecated
    public Double getValue(int n) {
        assert (n == 0) : "Incorrect dimension requested for 1-dimensional vector.";
        return this.val;
    }

    @Override
    public Vector getColumnVector() {
        return new Vector(this.val);
    }

    public static class Factory
    extends AbstractNumberVector.Factory<OneDimensionalDoubleVector> {
        @Override
        public <A> OneDimensionalDoubleVector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            assert (arrayAdapter.size(a) == 1) : "Incorrect dimensionality for 1-dimensional vector.";
            return new OneDimensionalDoubleVector(arrayAdapter.get(a, 0).doubleValue());
        }

        @Override
        public <A> OneDimensionalDoubleVector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            assert (numberArrayAdapter.size(a) == 1) : "Incorrect dimensionality for 1-dimensional vector.";
            return new OneDimensionalDoubleVector(numberArrayAdapter.getDouble(a, 0));
        }

        @Override
        public ByteBufferSerializer<OneDimensionalDoubleVector> getDefaultSerializer() {
            return null;
        }

        @Override
        public Class<? super OneDimensionalDoubleVector> getRestrictionClass() {
            return OneDimensionalDoubleVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return STATIC;
            }
        }
    }
}

