/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.AbstractNumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import gnu.trove.iterator.TIntDoubleIterator;
import gnu.trove.map.TIntDoubleMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SparseShortVector
extends AbstractNumberVector
implements SparseNumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<SparseShortVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final int[] indexes;
    private final short[] values;
    private int dimensionality;

    public SparseShortVector(int[] nArray, short[] sArray, int n) {
        this.indexes = nArray;
        this.values = sArray;
        this.dimensionality = n;
    }

    public SparseShortVector(TIntDoubleMap tIntDoubleMap, int n) throws IllegalArgumentException {
        int n2;
        if (tIntDoubleMap.size() > n) {
            throw new IllegalArgumentException("values.size() > dimensionality!");
        }
        this.indexes = new int[tIntDoubleMap.size()];
        this.values = new short[tIntDoubleMap.size()];
        TIntDoubleIterator tIntDoubleIterator = tIntDoubleMap.iterator();
        int n3 = 0;
        while (tIntDoubleIterator.hasNext()) {
            tIntDoubleIterator.advance();
            this.indexes[n3] = tIntDoubleIterator.key();
            ++n3;
        }
        Arrays.sort(this.indexes);
        for (n2 = 0; n2 < tIntDoubleMap.size(); ++n2) {
            this.values[n2] = (short)tIntDoubleMap.get(this.indexes[n2]);
        }
        this.dimensionality = n;
        n2 = this.getMaxDim();
        if (n2 > n) {
            throw new IllegalArgumentException("Given dimensionality " + n + " is too small w.r.t. the given values (occurring maximum: " + n2 + ").");
        }
    }

    private int getMaxDim() {
        if (this.indexes.length == 0) {
            return 0;
        }
        return this.indexes[this.indexes.length - 1];
    }

    public SparseShortVector(short[] sArray) throws IllegalArgumentException {
        int n;
        this.dimensionality = sArray.length;
        int n2 = 0;
        for (n = 0; n < sArray.length; ++n) {
            if (sArray[n] == 0) continue;
            ++n2;
        }
        this.indexes = new int[n2];
        this.values = new short[n2];
        n = 0;
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            if (s == 0) continue;
            this.indexes[n] = i;
            this.values[n] = s;
            ++n;
        }
    }

    @Override
    public int getDimensionality() {
        return this.dimensionality;
    }

    @Override
    public void setDimensionality(int n) throws IllegalArgumentException {
        int n2 = this.getMaxDim();
        if (n2 > n) {
            throw new IllegalArgumentException("Given dimensionality " + n + " is too small w.r.t. the given values (occurring maximum: " + n2 + ").");
        }
        this.dimensionality = n;
    }

    @Override
    @Deprecated
    public Short getValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return (short)0;
    }

    @Override
    @Deprecated
    public double doubleValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return 0.0;
    }

    @Override
    @Deprecated
    public long longValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return 0L;
    }

    @Override
    @Deprecated
    public short shortValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return 0;
    }

    @Override
    public Vector getColumnVector() {
        return new Vector(this.getValues());
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.indexes.length);
        for (int i = 0; i < this.indexes.length; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(this.indexes[i]);
            stringBuilder.append(" ");
            stringBuilder.append(this.values[i]);
        }
        return stringBuilder.toString();
    }

    private double[] getValues() {
        double[] dArray = new double[this.dimensionality];
        for (int i = 0; i < this.indexes.length; ++i) {
            dArray[this.indexes[i]] = this.values[i];
        }
        return dArray;
    }

    @Override
    public int iter() {
        return 0;
    }

    @Override
    public int iterDim(int n) {
        return this.indexes[n];
    }

    @Override
    public int iterAdvance(int n) {
        return n + 1;
    }

    @Override
    public boolean iterValid(int n) {
        return n < this.indexes.length;
    }

    @Override
    public double iterDoubleValue(int n) {
        return this.values[n];
    }

    @Override
    public float iterFloatValue(int n) {
        return this.values[n];
    }

    @Override
    public int iterIntValue(int n) {
        return this.values[n];
    }

    @Override
    public short iterShortValue(int n) {
        return this.values[n];
    }

    @Override
    public long iterLongValue(int n) {
        return this.values[n];
    }

    @Override
    public byte iterByteValue(int n) {
        return (byte)this.values[n];
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<SparseShortVector> {
        @Override
        public SparseShortVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            int n2 = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            int[] nArray = new int[n2];
            short[] sArray = new short[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = ByteArrayUtil.readUnsignedVarint(byteBuffer);
                sArray[i] = (short)ByteArrayUtil.readSignedVarint(byteBuffer);
            }
            return new SparseShortVector(nArray, sArray, n);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, SparseShortVector sparseShortVector) throws IOException {
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseShortVector.dimensionality);
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseShortVector.values.length);
            for (int i = 0; i < sparseShortVector.values.length; ++i) {
                ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseShortVector.indexes[i]);
                ByteArrayUtil.writeSignedVarint(byteBuffer, sparseShortVector.values[i]);
            }
        }

        @Override
        public int getByteSize(SparseShortVector sparseShortVector) {
            int n = 0;
            n += ByteArrayUtil.getUnsignedVarintSize(sparseShortVector.dimensionality);
            n += ByteArrayUtil.getUnsignedVarintSize(sparseShortVector.values.length);
            for (int i = 0; i < sparseShortVector.values.length; ++i) {
                n += ByteArrayUtil.getUnsignedVarintSize(sparseShortVector.indexes[i]);
                n += ByteArrayUtil.getSignedVarintSize(sparseShortVector.values[i]);
            }
            return n;
        }
    }

    public static class Factory
    extends AbstractNumberVector.Factory<SparseShortVector>
    implements SparseNumberVector.Factory<SparseShortVector> {
        @Override
        public <A> SparseShortVector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            int n = arrayAdapter.size(a);
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = arrayAdapter.get(a, i).shortValue();
            }
            return new SparseShortVector(sArray);
        }

        @Override
        public <A> SparseShortVector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            int n = numberArrayAdapter.size(a);
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = numberArrayAdapter.getShort(a, i);
            }
            return new SparseShortVector(sArray);
        }

        @Override
        public SparseShortVector newNumberVector(TIntDoubleMap tIntDoubleMap, int n) {
            return new SparseShortVector(tIntDoubleMap, n);
        }

        @Override
        public ByteBufferSerializer<SparseShortVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super SparseShortVector> getRestrictionClass() {
            return SparseShortVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

