/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.synthetic.bymodel;

import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorInterfaceDynamic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.AffineTransformation;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class GeneratorSingleCluster
implements GeneratorInterfaceDynamic,
Model {
    private List<Distribution> axes = new ArrayList<Distribution>();
    private AffineTransformation trans;
    private int dim;
    private Vector clipmin;
    private Vector clipmax;
    private double densitycorrection = 1.0;
    private int size;
    private String name;
    private int retries = 1000;
    private int discarded = 0;
    private Random random;

    public GeneratorSingleCluster(String string, int n, double d, Random random) {
        this.size = n;
        this.name = string;
        this.densitycorrection = d;
        this.random = random;
    }

    public void addGenerator(Distribution distribution) throws UnableToComplyException {
        if (this.trans != null) {
            throw new UnableToComplyException("Generators may no longer be added when transformations have been applied.");
        }
        this.axes.add(distribution);
        ++this.dim;
    }

    public void addRotation(int n, int n2, double d) {
        if (this.trans == null) {
            this.trans = new AffineTransformation(this.dim);
        }
        this.trans.addRotation(n, n2, d);
    }

    public void addTranslation(Vector vector) {
        if (this.trans == null) {
            this.trans = new AffineTransformation(this.dim);
        }
        this.trans.addTranslation(vector);
    }

    public void setClipping(Vector vector, Vector vector2) throws UnableToComplyException {
        if (vector.getDimensionality() == 1 && vector2.getDimensionality() == 1) {
            if (vector.get(0) >= vector2.get(0)) {
                throw new UnableToComplyException("Clipping range empty.");
            }
            this.clipmin = new Vector(this.dim);
            this.clipmax = new Vector(this.dim);
            for (int i = 0; i < this.dim; ++i) {
                this.clipmin.set(i, vector.get(0));
                this.clipmax.set(i, vector2.get(0));
            }
            return;
        }
        if (this.dim != vector.getDimensionality()) {
            throw new UnableToComplyException("Clipping vector dimensionalities do not match: " + this.dim + " vs. " + vector.getDimensionality());
        }
        if (this.dim != vector2.getDimensionality()) {
            throw new UnableToComplyException("Clipping vector dimensionalities do not match: " + this.dim + " vs. " + vector2.getDimensionality());
        }
        for (int i = 0; i < this.dim; ++i) {
            if (!(vector.get(i) >= vector2.get(i))) continue;
            throw new UnableToComplyException("Clipping range empty in dimension " + (i + 1));
        }
        this.clipmin = vector;
        this.clipmax = vector2;
    }

    @Override
    public int getDim() {
        return this.dim;
    }

    private boolean testClipping(Vector vector) {
        if (this.clipmin == null || this.clipmax == null) {
            return false;
        }
        for (int i = 0; i < vector.getDimensionality(); ++i) {
            if (vector.get(i) < this.clipmin.get(i)) {
                return true;
            }
            if (!(vector.get(i) > this.clipmax.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Vector> generate(int n) throws UnableToComplyException {
        ArrayList<Vector> arrayList = new ArrayList<Vector>(n);
        while (arrayList.size() < n) {
            double[] dArray = new double[this.dim];
            int n2 = 0;
            for (Distribution distribution : this.axes) {
                dArray[n2] = distribution.nextRandom();
                ++n2;
            }
            Object object = new Vector(dArray);
            if (this.trans != null) {
                object = this.trans.apply((Vector)object);
            }
            if (this.testClipping((Vector)object)) {
                --this.retries;
                if (this.retries >= 0) continue;
                throw new UnableToComplyException("Maximum retry count in generator exceeded.");
            }
            arrayList.add((Vector)object);
        }
        return arrayList;
    }

    @Override
    public double getDensity(Vector vector) {
        Vector vector2 = vector;
        if (this.trans != null) {
            vector2 = this.trans.applyInverse(vector);
        }
        double d = 1.0;
        int n = 0;
        for (Distribution distribution : this.axes) {
            d *= distribution.pdf(vector2.get(n));
            ++n;
        }
        return d * this.densitycorrection;
    }

    public AffineTransformation getTransformation() {
        return this.trans;
    }

    public Vector getClipmin() {
        if (this.clipmin == null) {
            return null;
        }
        return this.clipmin.copy();
    }

    public Vector getClipmax() {
        if (this.clipmax == null) {
            return null;
        }
        return this.clipmax.copy();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getDiscarded() {
        return this.discarded;
    }

    @Override
    public void incrementDiscarded() {
        ++this.discarded;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    public double getDensityCorrection() {
        return this.densitycorrection;
    }

    public void setDensityCorrection(double d) {
        this.densitycorrection = d;
    }

    public Random getNewRandomGenerator() {
        return new Random(this.random.nextLong());
    }

    @Override
    public Model makeModel() {
        return this;
    }

    public Distribution getDistribution(int n) {
        return this.axes.get(n);
    }
}

