/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.uncertain.AbstractUncertainObject;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.util.Random;

public class SimpleGaussianContinuousUncertainObject
extends AbstractUncertainObject {
    public static final FeatureVector.Factory<SimpleGaussianContinuousUncertainObject, ?> FACTORY = new Factory();
    private static final double DIV = 0.16666666666666666;

    public SimpleGaussianContinuousUncertainObject(SpatialComparable spatialComparable) {
        this.bounds = spatialComparable;
    }

    @Override
    public DoubleVector getCenterOfMass() {
        int n = this.bounds.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (this.bounds.getMin(i) + this.bounds.getMax(i)) * 0.5;
        }
        return new DoubleVector(dArray);
    }

    @Override
    public DoubleVector drawSample(Random random) {
        int n = this.bounds.getDimensionality();
        double[] dArray = new double[n];
        int n2 = 0;
        int n3 = 1000;
        while (n2 < n) {
            double d = this.bounds.getMin(n2);
            double d2 = this.bounds.getMax(n2);
            double d3 = (d2 - d) * 0.16666666666666666;
            assert (d3 < Double.POSITIVE_INFINITY);
            double d4 = random.nextGaussian() * d3 + (d + d2) * 0.5;
            if (d4 < d || d4 > d2) {
                if (--n3 != 0) continue;
                throw new AbortException("Could not satisfy bounding box!");
            }
            dArray[n2++] = d4;
        }
        return new DoubleVector(dArray);
    }

    private static class Factory
    implements FeatureVector.Factory<SimpleGaussianContinuousUncertainObject, Number> {
        private Factory() {
        }

        @Override
        public <A> SimpleGaussianContinuousUncertainObject newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBufferSerializer<SimpleGaussianContinuousUncertainObject> getDefaultSerializer() {
            return null;
        }

        @Override
        public Class<? super SimpleGaussianContinuousUncertainObject> getRestrictionClass() {
            return SimpleGaussianContinuousUncertainObject.class;
        }
    }
}

