/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreIDMap;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import java.util.Arrays;

public class ArrayStore<T>
implements WritableDataStore<T> {
    private Object[] data;
    private DataStoreIDMap idmap;

    public ArrayStore(Object[] objectArray, DataStoreIDMap dataStoreIDMap) {
        this.data = objectArray;
        this.idmap = dataStoreIDMap;
    }

    @Override
    public T get(DBIDRef dBIDRef) {
        int n = this.idmap.mapDBIDToOffset(dBIDRef);
        if (n < 0 || n >= this.data.length) {
            throw new ObjectNotFoundException(DBIDUtil.deref(dBIDRef));
        }
        return (T)this.data[n];
    }

    @Override
    public T put(DBIDRef dBIDRef, T t) {
        T t2 = this.get(dBIDRef);
        this.data[this.idmap.mapDBIDToOffset((DBIDRef)dBIDRef)] = t;
        return t2;
    }

    @Override
    public void destroy() {
        this.data = null;
        this.idmap = null;
    }

    @Override
    public void delete(DBIDRef dBIDRef) {
        this.put(dBIDRef, null);
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, null);
    }

    @Override
    public String getLongName() {
        return "raw";
    }

    @Override
    public String getShortName() {
        return "raw";
    }
}

