/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import gnu.trove.map.TIntDoubleMap;
import gnu.trove.map.hash.TIntDoubleHashMap;

public class MapIntegerDBIDDoubleStore
implements WritableDoubleDataStore {
    private TIntDoubleMap map;

    public MapIntegerDBIDDoubleStore(int n) {
        this(n, Double.NaN);
    }

    public MapIntegerDBIDDoubleStore(int n, double d) {
        this.map = new TIntDoubleHashMap(n, 0.5f, Integer.MIN_VALUE, d);
    }

    @Override
    @Deprecated
    public Double get(DBIDRef dBIDRef) {
        return this.map.get(DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public double doubleValue(DBIDRef dBIDRef) {
        return this.map.get(DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public String getLongName() {
        return "raw";
    }

    @Override
    public String getShortName() {
        return "raw";
    }

    @Override
    @Deprecated
    public Double put(DBIDRef dBIDRef, Double d) {
        return this.map.put(DBIDUtil.asInteger(dBIDRef), d);
    }

    @Override
    public void delete(DBIDRef dBIDRef) {
        this.map.remove(DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public double putDouble(DBIDRef dBIDRef, double d) {
        return this.map.put(DBIDUtil.asInteger(dBIDRef), d);
    }

    @Override
    public double put(DBIDRef dBIDRef, double d) {
        return this.map.put(DBIDUtil.asInteger(dBIDRef), d);
    }

    @Override
    public void increment(DBIDRef dBIDRef, double d) {
        this.map.adjustOrPutValue(DBIDUtil.asInteger(dBIDRef), d, this.map.getNoEntryValue() + d);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void destroy() {
        this.map.clear();
        this.map = null;
    }
}

