/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

public class MapIntegerDBIDStore<T>
implements WritableDataStore<T> {
    private TIntObjectMap<T> data;

    public MapIntegerDBIDStore(TIntObjectMap<T> tIntObjectMap) {
        this.data = tIntObjectMap;
    }

    public MapIntegerDBIDStore() {
        this.data = new TIntObjectHashMap<T>();
    }

    public MapIntegerDBIDStore(int n) {
        this.data = new TIntObjectHashMap<T>(n);
    }

    @Override
    public T get(DBIDRef dBIDRef) {
        return this.data.get(DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public T put(DBIDRef dBIDRef, T t) {
        if (t == null) {
            return this.data.remove(DBIDUtil.asInteger(dBIDRef));
        }
        return this.data.put(DBIDUtil.asInteger(dBIDRef), t);
    }

    @Override
    public void destroy() {
        this.data = null;
    }

    @Override
    public void delete(DBIDRef dBIDRef) {
        this.data.remove(DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public String getLongName() {
        return "raw";
    }

    @Override
    public String getShortName() {
        return "raw";
    }
}

