/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.knn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDistanceKNNQuery<O>
implements KNNQuery<O> {
    protected final Relation<? extends O> relation;
    protected final DistanceQuery<O> distanceQuery;

    public AbstractDistanceKNNQuery(DistanceQuery<O> distanceQuery) {
        this.relation = distanceQuery.getRelation();
        this.distanceQuery = distanceQuery;
    }

    @Override
    public List<? extends KNNList> getKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
        ArrayList<KNNList> arrayList = new ArrayList<KNNList>(arrayDBIDs.size());
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            arrayList.add(this.getKNNForDBID(dBIDArrayIter, n));
            dBIDArrayIter.advance();
        }
        return arrayList;
    }

    @Override
    public KNNList getKNNForDBID(DBIDRef dBIDRef, int n) {
        return this.getKNNForObject(this.relation.get(dBIDRef), n);
    }

    @Override
    public abstract KNNList getKNNForObject(O var1, int var2);
}

