/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.rknn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNAndRKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.List;

public class PreprocessorRKNNQuery<O>
implements RKNNQuery<O> {
    protected final Relation<? extends O> relation;
    private final MaterializeKNNAndRKNNPreprocessor<O> preprocessor;
    private boolean warned = false;

    public PreprocessorRKNNQuery(Relation<O> relation, MaterializeKNNAndRKNNPreprocessor<O> materializeKNNAndRKNNPreprocessor) {
        this.relation = relation;
        this.preprocessor = materializeKNNAndRKNNPreprocessor;
    }

    public PreprocessorRKNNQuery(Relation<O> relation, MaterializeKNNAndRKNNPreprocessor.Factory<O> factory) {
        this(relation, (MaterializeKNNAndRKNNPreprocessor<O>)factory.instantiate((Relation)relation));
    }

    @Override
    public DoubleDBIDList getRKNNForDBID(DBIDRef dBIDRef, int n) {
        if (!this.warned && n != this.preprocessor.getK()) {
            LoggingUtil.warning("Requested more neighbors than preprocessed!");
        }
        return this.preprocessor.getRKNN(dBIDRef);
    }

    @Override
    public DoubleDBIDList getRKNNForObject(O o, int n) {
        throw new AbortException("Preprocessor KNN query only supports ID queries.");
    }

    @Override
    public List<? extends DoubleDBIDList> getRKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
        if (!this.warned && n != this.preprocessor.getK()) {
            LoggingUtil.warning("Requested more neighbors than preprocessed!");
        }
        ArrayList<DoubleDBIDList> arrayList = new ArrayList<DoubleDBIDList>(arrayDBIDs.size());
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            arrayList.add(this.preprocessor.getRKNN(dBIDArrayIter));
            dBIDArrayIter.advance();
        }
        return arrayList;
    }
}

