/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.Arrays;

public class ArrayAdapterDatabaseConnection
implements DatabaseConnection {
    double[][] data;
    String[] labels;
    Integer startid = null;

    public ArrayAdapterDatabaseConnection(double[][] dArray) {
        this(dArray, null, null);
    }

    public ArrayAdapterDatabaseConnection(double[][] dArray, String[] stringArray) {
        this(dArray, stringArray, null);
    }

    public ArrayAdapterDatabaseConnection(double[][] dArray, String[] stringArray, Integer n) {
        this.data = dArray;
        this.labels = stringArray;
        this.startid = n;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        MultipleObjectsBundle multipleObjectsBundle = new MultipleObjectsBundle();
        if (this.startid != null) {
            multipleObjectsBundle.setDBIDs(DBIDFactory.FACTORY.generateStaticDBIDRange(this.startid, this.data.length));
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        ArrayList<DoubleVector> arrayList = new ArrayList<DoubleVector>(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            n = Math.min(n, this.data[i].length);
            n2 = Math.max(n2, this.data[i].length);
            arrayList.add(new DoubleVector(this.data[i]));
        }
        VectorFieldTypeInformation<DoubleVector> vectorFieldTypeInformation = new VectorFieldTypeInformation<DoubleVector>(DoubleVector.FACTORY, n, n2, DoubleVector.FACTORY.getDefaultSerializer());
        multipleObjectsBundle.appendColumn(vectorFieldTypeInformation, arrayList);
        if (this.labels != null) {
            if (this.labels.length != this.data.length) {
                throw new AbortException("Label and DBID columns must have the same size.");
            }
            multipleObjectsBundle.appendColumn(TypeUtil.STRING, Arrays.asList(this.labels));
        }
        return multipleObjectsBundle;
    }
}

