/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.FileBasedDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.datasource.parser.Parser;
import de.lmu.ifi.dbs.elki.datasource.parser.StreamingParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileListParameter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ConcatenateFilesDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(ConcatenateFilesDatabaseConnection.class);
    private List<File> files;
    private Parser parser;

    public ConcatenateFilesDatabaseConnection(List<File> list, Parser parser, List<ObjectFilter> list2) {
        super(list2);
        this.files = list;
        this.parser = parser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MultipleObjectsBundle loadData() {
        MultipleObjectsBundle multipleObjectsBundle = new MultipleObjectsBundle();
        multipleObjectsBundle.appendColumn(TypeUtil.STRING, new ArrayList());
        block7: for (File file : this.files) {
            String string = file.getPath();
            try {
                Object object;
                Object object2;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                InputStream inputStream = FileUtil.tryGzipInput(bufferedInputStream);
                if (this.parser instanceof StreamingParser) {
                    object2 = (StreamingParser)this.parser;
                    object2.initStream(inputStream);
                    object = object2;
                } else {
                    object2 = this.parser.parse(inputStream);
                    object = ((MultipleObjectsBundle)object2).asStream();
                }
                object2 = null;
                BundleStreamSource.Event event = object.nextEvent();
                while (true) {
                    switch (event) {
                        case END_OF_STREAM: {
                            continue block7;
                        }
                        case META_CHANGED: {
                            object2 = object.getMeta();
                            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                                if (i + 1 >= multipleObjectsBundle.metaLength()) {
                                    multipleObjectsBundle.appendColumn((SimpleTypeInformation)((ArrayList)object2).get(i), new ArrayList());
                                    continue;
                                }
                                if (multipleObjectsBundle.meta(i + 1).isAssignableFromType((TypeInformation)((ArrayList)object2).get(i))) continue;
                                throw new AbortException("Incompatible files loaded. Cannot concatenate with unaligned columns, please preprocess manually.");
                            }
                            break;
                        }
                        case NEXT_OBJECT: {
                            Object[] objectArray = new Object[multipleObjectsBundle.metaLength()];
                            objectArray[0] = string;
                            for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                                objectArray[i + 1] = object.data(i);
                            }
                            multipleObjectsBundle.appendSimple(objectArray);
                        }
                    }
                    event = object.nextEvent();
                }
            }
            catch (IOException iOException) {
                throw new AbortException("Loading file " + string + " failed: " + iOException.toString(), iOException);
            }
        }
        this.parser.cleanup();
        if (LOG.isDebugging()) {
            LOG.debugFine("Invoking filters.");
        }
        return this.invokeBundleFilters(multipleObjectsBundle);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        private List<File> files;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            FileListParameter fileListParameter = new FileListParameter(FileBasedDatabaseConnection.Parameterizer.INPUT_ID, FileListParameter.FilesType.INPUT_FILES);
            if (parameterization.grab(fileListParameter)) {
                this.files = (List)fileListParameter.getValue();
            }
            this.configFilters(parameterization);
            this.configParser(parameterization, Parser.class, NumberVectorLabelParser.class);
        }

        @Override
        protected ConcatenateFilesDatabaseConnection makeInstance() {
            return new ConcatenateFilesDatabaseConnection(this.files, this.parser, this.filters);
        }
    }
}

