/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.List;

public abstract class AbstractConversionFilter<I, O>
implements ObjectFilter {
    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        if (multipleObjectsBundle.dataLength() == 0) {
            return multipleObjectsBundle;
        }
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        Logging logging = this.getLogger();
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            Object obj;
            Object object;
            Object object2;
            SimpleTypeInformation<?> simpleTypeInformation = multipleObjectsBundle.meta(i);
            List<?> list = multipleObjectsBundle.getColumn(i);
            if (!this.getInputTypeRestriction().isAssignableFromType(simpleTypeInformation)) {
                multipleObjectsBundle2.appendColumn(simpleTypeInformation, list);
                continue;
            }
            SimpleTypeInformation<?> simpleTypeInformation2 = simpleTypeInformation;
            if (this.prepareStart(simpleTypeInformation2)) {
                object2 = logging.isVerbose() ? new FiniteProgress("Preparing normalization", multipleObjectsBundle.dataLength(), logging) : null;
                object = list.iterator();
                while (object.hasNext()) {
                    Object obj2;
                    obj = obj2 = object.next();
                    this.prepareProcessInstance(obj);
                    logging.incrementProcessed((AbstractProgress)object2);
                }
                logging.ensureCompleted((FiniteProgress)object2);
                this.prepareComplete();
            }
            object2 = list;
            multipleObjectsBundle2.appendColumn(this.convertedType(simpleTypeInformation2), (List<?>)object2);
            object = logging.isVerbose() ? new FiniteProgress("Data normalization", multipleObjectsBundle.dataLength(), logging) : null;
            for (int j = 0; j < multipleObjectsBundle.dataLength(); ++j) {
                obj = list.get(j);
                O o = this.filterSingleObject(obj);
                object2.set(j, o);
                logging.incrementProcessed((AbstractProgress)object);
            }
            logging.ensureCompleted((FiniteProgress)object);
        }
        return multipleObjectsBundle2;
    }

    protected abstract Logging getLogger();

    protected abstract O filterSingleObject(I var1);

    protected abstract SimpleTypeInformation<? super I> getInputTypeRestriction();

    protected abstract SimpleTypeInformation<? super O> convertedType(SimpleTypeInformation<I> var1);

    protected boolean prepareStart(SimpleTypeInformation<I> simpleTypeInformation) {
        return false;
    }

    protected void prepareProcessInstance(I i) {
        throw new AbortException("ProcessInstance not implemented, but prepareStart true?");
    }

    protected void prepareComplete() {
    }
}

