/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.instancewise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.AbstractStreamNormalization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class InstanceMeanVarianceNormalization<V extends NumberVector>
extends AbstractStreamNormalization<V> {
    private int multiplicity;

    @Override
    protected V filterSingleObject(V v) {
        double[] dArray = v.getColumnVector().getArrayRef();
        if (dArray.length == 0) {
            return this.factory.newNumberVector(new double[0]);
        }
        if (dArray.length == 1) {
            return this.factory.newNumberVector(new double[]{dArray[0] == dArray[0] ? 0.0 : Double.NaN});
        }
        if (this.multiplicity > 1) {
            assert (dArray.length % this.multiplicity == 0) : "Vector length is not divisible by multiplicity?";
            return this.factory.newNumberVector(this.multivariateStandardization(dArray));
        }
        return this.factory.newNumberVector(this.univariateStandardization(dArray));
    }

    protected double[] univariateStandardization(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            if (d2 != d2) continue;
            d += d2;
        }
        double d3 = d / (double)dArray.length;
        double d4 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d5 = dArray[i] - d3;
            if (d5 != d5) continue;
            d4 += d5 * d5;
        }
        double d6 = Math.sqrt(d4) / (double)(dArray.length - 1);
        if (d6 > 0.0) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (dArray[i] - d3) / d6;
            }
        }
        return dArray;
    }

    protected double[] multivariateStandardization(double[] dArray) {
        int n = dArray.length / this.multiplicity;
        if (n <= 1) {
            return dArray;
        }
        double[] dArray2 = new double[this.multiplicity];
        int n2 = 0;
        int n3 = 0;
        while (n2 < dArray.length) {
            double d = dArray[n2];
            if (d == d) {
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + d;
            }
            ++n2;
            ++n3;
            n3 %= this.multiplicity;
        }
        n2 = 0;
        while (n2 < this.multiplicity) {
            int n5 = n2++;
            dArray2[n5] = dArray2[n5] / (double)n;
        }
        double[] dArray3 = new double[this.multiplicity];
        n3 = 0;
        int n6 = 0;
        while (n3 < dArray.length) {
            double d = dArray[n3] - dArray2[n6];
            if (d == d) {
                int n7 = n6;
                dArray3[n7] = dArray3[n7] + d * d;
            }
            ++n3;
            ++n6;
            n6 %= this.multiplicity;
        }
        for (n3 = 0; n3 < this.multiplicity; ++n3) {
            dArray3[n3] = dArray3[n3] > 0.0 ? Math.sqrt(dArray3[n3]) / (double)(n - 1) : 1.0;
        }
        n3 = 0;
        n6 = 0;
        while (n3 < dArray.length) {
            dArray[n3] = (dArray[n3] - dArray2[n6]) / dArray3[n6];
            ++n3;
            ++n6;
            n6 %= this.multiplicity;
        }
        return dArray;
    }

    @Override
    protected void initializeOutputType(SimpleTypeInformation<V> simpleTypeInformation) {
        super.initializeOutputType(simpleTypeInformation);
        this.multiplicity = ((VectorTypeInformation)simpleTypeInformation).getMultiplicity();
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        @Override
        protected InstanceMeanVarianceNormalization<V> makeInstance() {
            return new InstanceMeanVarianceNormalization();
        }
    }
}

