/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.selection;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.ByLabelFilter", "de.lmu.ifi.dbs.elki.datasource.filter.FilterByLabelFilter"})
public class ByLabelFilter
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(ByLabelFilter.class);
    private final Matcher matcher;
    private final boolean inverted;
    private int lblcol = -1;

    public ByLabelFilter(Pattern pattern, boolean bl) {
        this.matcher = pattern.matcher("");
        this.inverted = bl;
    }

    @Override
    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    @Override
    public Object data(int n) {
        return this.source.data(n);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event event = this.source.nextEvent();
            switch (event) {
                case END_OF_STREAM: {
                    if (this.lblcol < 0) {
                        LOG.warning("By label filter was used, but never saw a label relation!");
                    }
                    return BundleStreamSource.Event.END_OF_STREAM;
                }
                case META_CHANGED: {
                    Object object;
                    if (this.lblcol < 0) {
                        object = this.source.getMeta();
                        this.lblcol = FilterUtil.findLabelColumn((BundleMeta)object);
                    }
                    return BundleStreamSource.Event.META_CHANGED;
                }
                case NEXT_OBJECT: {
                    Object object;
                    if (this.lblcol > 0) {
                        object = this.source.data(this.lblcol);
                        if (object instanceof LabelList) {
                            boolean bl = false;
                            LabelList labelList = (LabelList)object;
                            for (int i = 0; i < labelList.size(); ++i) {
                                this.matcher.reset(labelList.get(i));
                                if (!this.matcher.matches()) continue;
                                bl = true;
                                break;
                            }
                            if (bl == this.inverted) {
                                continue block5;
                            }
                        } else {
                            this.matcher.reset(object.toString());
                            if (!this.matcher.matches()) {
                                continue block5;
                            }
                        }
                    } else if (!this.inverted) continue block5;
                    return BundleStreamSource.Event.NEXT_OBJECT;
                }
            }
            LOG.warning("Unknown event: " + (Object)((Object)event));
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID LABELFILTER_PATTERN_ID = new OptionID("patternfilter.pattern", "The filter pattern to use.");
        public static final OptionID LABELFILTER_PATTERN_INVERT_ID = new OptionID("patternfilter.invert", "Flag to invert pattern.");
        Pattern pattern = null;
        private boolean inverted = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(LABELFILTER_PATTERN_ID);
            if (parameterization.grab(patternParameter)) {
                this.pattern = (Pattern)patternParameter.getValue();
            }
            if (parameterization.grab(flag = new Flag(LABELFILTER_PATTERN_INVERT_ID))) {
                this.inverted = (Boolean)flag.getValue();
            }
        }

        @Override
        protected ByLabelFilter makeInstance() {
            return new ByLabelFilter(this.pattern, this.inverted);
        }
    }
}

