/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.SimpleClassLabel;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import gnu.trove.list.array.TIntArrayList;
import java.util.regex.Pattern;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.ClassLabelFromPatternFilter"})
public class ClassLabelFromPatternFilter
extends AbstractStreamFilter {
    BundleMeta meta = null;
    TIntArrayList labelcols = new TIntArrayList();
    SimpleClassLabel positive;
    SimpleClassLabel negative;
    Pattern pattern;

    public ClassLabelFromPatternFilter(Pattern pattern, String string, String string2) {
        this.pattern = pattern;
        this.positive = new SimpleClassLabel(string);
        this.negative = new SimpleClassLabel(string2);
    }

    public ClassLabelFromPatternFilter(Pattern pattern, SimpleClassLabel simpleClassLabel, SimpleClassLabel simpleClassLabel2) {
        this.pattern = pattern;
        this.positive = simpleClassLabel;
        this.negative = simpleClassLabel2;
    }

    @Override
    public BundleMeta getMeta() {
        if (this.meta == null) {
            BundleMeta bundleMeta = this.source.getMeta();
            this.meta = new BundleMeta(bundleMeta.size() + 1);
            this.meta.add(TypeUtil.SIMPLE_CLASSLABEL);
            this.labelcols.clear();
            for (int i = 0; i < bundleMeta.size(); ++i) {
                SimpleTypeInformation simpleTypeInformation = (SimpleTypeInformation)bundleMeta.get(i);
                if (TypeUtil.GUESSED_LABEL.isAssignableFromType(simpleTypeInformation)) {
                    this.labelcols.add(i);
                }
                this.meta.add(simpleTypeInformation);
            }
        }
        return this.meta;
    }

    @Override
    public Object data(int n) {
        if (n > 0) {
            return this.source.data(n - 1);
        }
        if (this.meta == null) {
            this.getMeta();
        }
        for (int i = 0; i < this.labelcols.size(); ++i) {
            Object object = this.source.data(this.labelcols.get(i));
            if (object == null) continue;
            if (object instanceof LabelList) {
                LabelList labelList = (LabelList)object;
                for (int j = 0; j < labelList.size(); ++j) {
                    if (!this.pattern.matcher(labelList.get(j)).find()) continue;
                    return this.positive;
                }
                continue;
            }
            if (!this.pattern.matcher(object.toString()).find()) continue;
            return this.positive;
        }
        return this.negative;
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        BundleStreamSource.Event event = this.source.nextEvent();
        if (BundleStreamSource.Event.META_CHANGED.equals((Object)event)) {
            this.meta = null;
        }
        return event;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PATTERN_ID = new OptionID("class.pattern", "Regular expression to identify positive objects.");
        public static final OptionID POSITIVE_ID = new OptionID("class.positive", "Class label to use for positive instances.");
        public static final OptionID NEGATIVE_ID = new OptionID("class.negative", "Class label to use for negative instances.");
        Pattern pattern;
        String positive;
        String negative;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            StringParameter stringParameter;
            StringParameter stringParameter2;
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(PATTERN_ID);
            if (parameterization.grab(patternParameter)) {
                this.pattern = (Pattern)patternParameter.getValue();
            }
            if (parameterization.grab(stringParameter2 = new StringParameter(POSITIVE_ID, "positive"))) {
                this.positive = (String)stringParameter2.getValue();
            }
            if (parameterization.grab(stringParameter = new StringParameter(NEGATIVE_ID, "negative"))) {
                this.negative = (String)stringParameter.getValue();
            }
        }

        @Override
        protected ClassLabelFromPatternFilter makeInstance() {
            return new ClassLabelFromPatternFilter(this.pattern, this.positive, this.negative);
        }
    }
}

