/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseFloatVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import gnu.trove.map.hash.TIntDoubleHashMap;
import java.util.ArrayList;
import java.util.regex.Pattern;

@Title(value="Sparse Vector Label Parser")
@Description(value="Parser for the following line format:\nA single line provides a single point. Entries are separated by whitespace. The values will be parsed as floats (resulting in a set of SparseFloatVectors). A line is expected in the following format: The first entry of each line is the number of attributes with coordinate value not zero. Subsequent entries are of the form (index, value), where index is the number of the corresponding dimension, and value is the value of the corresponding attribute.Any pair of two subsequent substrings not containing whitespace is tried to be read as int and float. If this fails for the first of the pair (interpreted ans index), it will be appended to a label. (Thus, any label must not be parseable as Integer.) If the float component is not parseable, an exception will be thrown. Empty lines and lines beginning with \"#\" will be ignored.")
public class SparseNumberVectorLabelParser<V extends SparseNumberVector>
extends NumberVectorLabelParser<V> {
    private static final Logging LOG = Logging.getLogger(SparseNumberVectorLabelParser.class);
    protected SparseNumberVector.Factory<V> sparsefactory;
    TIntDoubleHashMap values = new TIntDoubleHashMap();
    ArrayList<String> labels = new ArrayList();

    public SparseNumberVectorLabelParser(CSVReaderFormat cSVReaderFormat, long[] lArray, SparseNumberVector.Factory<V> factory) {
        super(cSVReaderFormat, lArray, factory);
        this.sparsefactory = factory;
    }

    public SparseNumberVectorLabelParser(Pattern pattern, String string, Pattern pattern2, long[] lArray, SparseNumberVector.Factory<V> factory) {
        super(pattern, string, pattern2, lArray, factory);
        this.sparsefactory = factory;
    }

    @Override
    protected boolean parseLineInternal() {
        int n = (int)this.tokenizer.getLongBase10();
        this.tokenizer.advance();
        int n2 = 0;
        while (this.tokenizer.valid()) {
            if (this.values.size() < n) {
                try {
                    int n3 = (int)this.tokenizer.getLongBase10();
                    this.tokenizer.advance();
                    if (!this.isLabelColumn(n3)) {
                        if (!this.tokenizer.valid()) {
                            throw new AbortException("Parser expected double value, but line ended too early: " + this.reader.getLineNumber());
                        }
                        double d = this.tokenizer.getDouble();
                        n2 = n3 >= n2 ? n3 + 1 : n2;
                        this.values.put(n3, d);
                        this.tokenizer.advance();
                        continue;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.haslabels = true;
            this.labels.add(this.tokenizer.getSubstring());
            this.tokenizer.advance();
        }
        this.curvec = this.sparsefactory.newNumberVector(this.values, n2);
        this.curlbl = LabelList.make(this.labels);
        this.values.clear();
        this.labels.clear();
        return true;
    }

    @Override
    protected SimpleTypeInformation<V> getTypeInformation(int n, int n2) {
        if (n == n2) {
            return new VectorFieldTypeInformation(this.factory, n);
        }
        if (n < n2) {
            return new VectorTypeInformation(this.factory, this.factory.getDefaultSerializer(), n, n2);
        }
        throw new AbortException("No vectors were read from the input file - cannot determine vector data type.");
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends SparseNumberVector>
    extends NumberVectorLabelParser.Parameterizer<V> {
        @Override
        protected void getFactory(Parameterization parameterization) {
            ObjectParameter objectParameter = new ObjectParameter(VECTOR_TYPE_ID, (Class<?>)SparseNumberVector.Factory.class, SparseFloatVector.Factory.class);
            if (parameterization.grab(objectParameter)) {
                this.factory = (NumberVector.Factory)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected SparseNumberVectorLabelParser<V> makeInstance() {
            return new SparseNumberVectorLabelParser(this.format, this.labelIndices, (SparseNumberVector.Factory)this.factory);
        }
    }
}

