/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.datasource.parser.Parser;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Title(value="String Parser")
@Description(value="Parses new line separated strings")
public class StringParser
implements Parser {
    Matcher comment;
    boolean trimWhitespace;

    public StringParser(Pattern pattern, boolean bl) {
        this.comment = pattern != null ? pattern.matcher("") : null;
        this.trimWhitespace = bl;
    }

    @Override
    public MultipleObjectsBundle parse(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<LabelList> arrayList2 = new ArrayList<LabelList>();
        ArrayList<String> arrayList3 = new ArrayList<String>(1);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (!(string.length() <= 0 || this.comment != null && this.comment.reset(string).matches())) {
                    String string2 = this.trimWhitespace ? string.trim() : string;
                    arrayList.add(string2);
                    arrayList3.clear();
                    arrayList3.add(string2);
                    arrayList2.add(LabelList.make(arrayList3));
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error while parsing line " + n + ".");
        }
        return MultipleObjectsBundle.makeSimple(TypeUtil.STRING, arrayList, TypeUtil.LABELLIST, arrayList2);
    }

    @Override
    public void cleanup() {
        this.comment.reset("");
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID TRIM_ID = new OptionID("string.trim", "Remove leading and trailing whitespace from each line.");
        Pattern comment = null;
        boolean trimWhitespace = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(CSVReaderFormat.Parameterizer.COMMENT_ID, "^\\s*#.*$");
            if (parameterization.grab(patternParameter)) {
                this.comment = (Pattern)patternParameter.getValue();
            }
            if (parameterization.grab(flag = new Flag(TRIM_ID))) {
                this.trimWhitespace = flag.isTrue();
            }
        }

        @Override
        protected StringParser makeInstance() {
            return new StringParser(this.comment, this.trimWhitespace);
        }
    }
}

