/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="G. N. Lance, W. T. Williams", title="Computer programs for hierarchical polythetic classification (similarity analyses)", booktitle="Computer Journal, Volume 9, Issue 1", url="http://comjnl.oxfordjournals.org/content/9/1/60.short")
@Alias(value={"canberra"})
public class CanberraDistanceFunction
extends AbstractSpatialDistanceFunction {
    public static final CanberraDistanceFunction STATIC = new CanberraDistanceFunction();

    protected CanberraDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n;
        int n2;
        int n3 = numberVector.getDimensionality();
        int n4 = n3 < (n2 = numberVector2.getDimensionality()) ? n3 : n2;
        double d = 0.0;
        for (n = 0; n < n4; ++n) {
            double d2 = numberVector.doubleValue(n);
            double d3 = numberVector2.doubleValue(n);
            double d4 = Math.abs(d2) + Math.abs(d3);
            if (!(d4 > 0.0)) continue;
            d += Math.abs(d2 - d3) / d4;
        }
        for (n = n4; n < n3; ++n) {
            if (numberVector.doubleValue(n) == 0.0) continue;
            d += 1.0;
        }
        for (n = n4; n < n2; ++n) {
            if (numberVector2.doubleValue(n) == 0.0) continue;
            d += 1.0;
        }
        return d;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n;
        int n2;
        int n3 = spatialComparable.getDimensionality();
        int n4 = n3 < (n2 = spatialComparable2.getDimensionality()) ? n3 : n2;
        double d = 0.0;
        for (n = 0; n < n4; ++n) {
            double d2;
            if (spatialComparable.getMax(n) < spatialComparable2.getMin(n)) {
                d2 = spatialComparable2.getMin(n) - spatialComparable.getMax(n);
            } else {
                if (!(spatialComparable.getMin(n) > spatialComparable2.getMax(n))) continue;
                d2 = spatialComparable.getMin(n) - spatialComparable2.getMax(n);
            }
            double d3 = Math.max(-spatialComparable.getMin(n), spatialComparable.getMax(n));
            double d4 = Math.max(-spatialComparable2.getMin(n), spatialComparable2.getMax(n));
            double d5 = d3 + d4;
            d += d2 / d5;
        }
        for (n = n4; n < n3; ++n) {
            if (!(spatialComparable.getMin(n) > 0.0) && !(spatialComparable.getMax(n) < 0.0)) continue;
            d += 1.0;
        }
        for (n = n4; n < n2; ++n) {
            if (!(spatialComparable2.getMin(n) > 0.0) && !(spatialComparable2.getMax(n) < 0.0)) continue;
            d += 1.0;
        }
        return d;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected CanberraDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

