/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"cosine"})
public class CosineDistanceFunction
extends AbstractSpatialDistanceFunction {
    public static final CosineDistanceFunction STATIC = new CosineDistanceFunction();

    @Deprecated
    public CosineDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        double d = 1.0 - VectorUtil.cosAngle(numberVector, numberVector2);
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        double d = 1.0 - VectorUtil.minCosAngle(spatialComparable, spatialComparable2);
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    public String toString() {
        return "CosineDistance";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.getClass().equals(object.getClass());
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected CosineDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

