/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="M.-M. Deza and E. Deza", title="Dictionary of distances", booktitle="Dictionary of distances")
public class Kulczynski1DistanceFunction
extends AbstractSpatialDistanceFunction {
    public static final Kulczynski1DistanceFunction STATIC = new Kulczynski1DistanceFunction();

    @Deprecated
    public Kulczynski1DistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = Kulczynski1DistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = numberVector.doubleValue(i);
            double d4 = numberVector2.doubleValue(i);
            d += Math.abs(d3 - d4);
            d2 += Math.min(d3, d4);
        }
        return d / d2;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = Kulczynski1DistanceFunction.dimensionality(spatialComparable, spatialComparable2);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = spatialComparable.getMin(i);
            double d4 = spatialComparable.getMax(i);
            double d5 = spatialComparable2.getMin(i);
            double d6 = spatialComparable2.getMax(i);
            if (d4 < d5) {
                d += d5 - d4;
            } else if (d3 > d6) {
                d += d3 - d6;
            }
            d2 += Math.min(d3, d5);
        }
        return d / d2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected Kulczynski1DistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

