/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;

public class WeightedCanberraDistanceFunction
extends AbstractSpatialDistanceFunction
implements WeightedNumberVectorDistanceFunction<NumberVector> {
    protected double[] weights;

    public WeightedCanberraDistanceFunction(double[] dArray) {
        this.weights = dArray;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = WeightedCanberraDistanceFunction.dimensionality(numberVector, numberVector2, this.weights.length);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(i);
            double d3 = numberVector2.doubleValue(i);
            double d4 = Math.abs(d2) + Math.abs(d3);
            if (!(d4 > 0.0)) continue;
            d += this.weights[i] * Math.abs(d2 - d3) / d4;
        }
        return d;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = WeightedCanberraDistanceFunction.dimensionality(spatialComparable, spatialComparable2, this.weights.length);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            if (spatialComparable.getMax(i) < spatialComparable2.getMin(i)) {
                d2 = spatialComparable2.getMin(i) - spatialComparable.getMax(i);
            } else {
                if (!(spatialComparable.getMin(i) > spatialComparable2.getMax(i))) continue;
                d2 = spatialComparable.getMin(i) - spatialComparable2.getMax(i);
            }
            double d3 = Math.max(-spatialComparable.getMin(i), spatialComparable.getMax(i));
            double d4 = Math.max(-spatialComparable2.getMin(i), spatialComparable2.getMax(i));
            double d5 = d3 + d4;
            d += this.weights[i] * d2 / d5;
        }
        return d;
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected double[] weights;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleListParameter doubleListParameter = new DoubleListParameter(WeightedNumberVectorDistanceFunction.WEIGHTS_ID);
            if (parameterization.grab(doubleListParameter)) {
                this.weights = (double[])((double[])doubleListParameter.getValue()).clone();
            }
        }

        @Override
        protected WeightedCanberraDistanceFunction makeInstance() {
            return new WeightedCanberraDistanceFunction(this.weights);
        }
    }
}

