/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.adapter;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDatabaseDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.NormalizedSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractSimilarityAdapter<O>
extends AbstractDatabaseDistanceFunction<O> {
    protected SimilarityFunction<? super O> similarityFunction;

    public AbstractSimilarityAdapter(SimilarityFunction<? super O> similarityFunction) {
        this.similarityFunction = similarityFunction;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.similarityFunction.getInputTypeRestriction();
    }

    @Override
    public boolean isSymmetric() {
        return this.similarityFunction.isSymmetric();
    }

    @Override
    public abstract <T extends O> DistanceQuery<T> instantiate(Relation<T> var1);

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractSimilarityAdapter abstractSimilarityAdapter = (AbstractSimilarityAdapter)object;
        return abstractSimilarityAdapter.similarityFunction.equals(abstractSimilarityAdapter.similarityFunction);
    }

    public static abstract class Parameterizer<O, S extends SimilarityFunction<? super O>>
    extends AbstractParameterizer {
        public static final OptionID SIMILARITY_FUNCTION_ID = new OptionID("adapter.similarityfunction", "Similarity function to derive the distance between database objects from.");
        protected S similarityFunction = null;
        protected Class<SimilarityFunction<? super O>> ARBITRARY_SIMILARITY = ClassGenericsUtil.uglyCastIntoSubclass(SimilarityFunction.class);
        protected Class<NormalizedSimilarityFunction<? super O>> NORMALIZED_SIMILARITY = ClassGenericsUtil.uglyCastIntoSubclass(NormalizedSimilarityFunction.class);

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(SIMILARITY_FUNCTION_ID, this.getSimilarityRestriction());
            if (parameterization.grab(objectParameter)) {
                this.similarityFunction = (SimilarityFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        protected abstract Class<? extends S> getSimilarityRestriction();
    }

    public static abstract class Instance<O>
    extends AbstractDatabaseDistanceFunction.Instance<O> {
        private SimilarityQuery<? super O> similarityQuery;

        public Instance(Relation<O> relation, DistanceFunction<? super O> distanceFunction, SimilarityQuery<? super O> similarityQuery) {
            super(relation, distanceFunction);
            this.similarityQuery = similarityQuery;
        }

        public abstract double transform(double var1);

        @Override
        public double distance(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            return this.transform(this.similarityQuery.similarity(dBIDRef, dBIDRef2));
        }
    }
}

