/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.external;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDBIDRangeDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.AsciiDistanceParser;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceCacheWriter;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceParser;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.FileBasedDoubleDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import gnu.trove.map.TLongFloatMap;
import gnu.trove.map.hash.TLongFloatHashMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

@Title(value="File based float distance for database objects.")
@Description(value="Loads float distance values from an external text file.")
public class FileBasedFloatDistanceFunction
extends AbstractDBIDRangeDistanceFunction {
    private static final Logging LOG = Logging.getLogger(FileBasedFloatDistanceFunction.class);
    private TLongFloatMap cache;
    private DistanceParser parser;
    private File matrixfile;
    private int min;
    private int max;

    public FileBasedFloatDistanceFunction(DistanceParser distanceParser, File file) {
        this.parser = distanceParser;
        this.matrixfile = file;
    }

    @Override
    public <O extends DBID> DistanceQuery<O> instantiate(Relation<O> relation) {
        if (this.cache == null) {
            try {
                this.loadCache(this.parser, this.matrixfile);
            }
            catch (IOException iOException) {
                throw new AbortException("Could not load external distance file: " + this.matrixfile.toString(), iOException);
            }
        }
        return super.instantiate(relation);
    }

    @Override
    public double distance(int n, int n2) {
        return n == n2 ? 0.0 : (double)this.cache.get(FileBasedFloatDistanceFunction.makeKey(n + this.min, n2 + this.min));
    }

    private void loadCache(DistanceParser distanceParser, File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(FileUtil.tryGzipInput(new FileInputStream(file)));
        this.cache = new TLongFloatHashMap(10, 0.5f, -1L, Float.POSITIVE_INFINITY);
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        distanceParser.parse(bufferedInputStream, new DistanceCacheWriter(){

            @Override
            public void put(int n, int n2, double d) {
                if (n < n2) {
                    FileBasedFloatDistanceFunction.this.min = n < FileBasedFloatDistanceFunction.this.min ? n : FileBasedFloatDistanceFunction.this.min;
                    FileBasedFloatDistanceFunction.this.max = n2 > FileBasedFloatDistanceFunction.this.max ? n2 : FileBasedFloatDistanceFunction.this.max;
                } else {
                    FileBasedFloatDistanceFunction.this.min = n2 < FileBasedFloatDistanceFunction.this.min ? n2 : FileBasedFloatDistanceFunction.this.min;
                    FileBasedFloatDistanceFunction.this.max = n > FileBasedFloatDistanceFunction.this.max ? n : FileBasedFloatDistanceFunction.this.max;
                }
                FileBasedFloatDistanceFunction.this.cache.put(FileBasedFloatDistanceFunction.makeKey(n, n2), (float)d);
            }

            @Override
            public boolean containsKey(int n, int n2) {
                return FileBasedFloatDistanceFunction.this.cache.containsKey(FileBasedFloatDistanceFunction.makeKey(n, n2));
            }
        });
        if (this.min != 0) {
            LOG.verbose("Distance matrix is supposed to be 0-indexed. Choosing offset " + this.min + " to compensate.");
        }
    }

    protected static final long makeKey(int n, int n2) {
        return n < n2 ? (long)n << 32 | (long)n2 : (long)n2 << 32 | (long)n;
    }

    @Override
    public void checkRange(DBIDRange dBIDRange) {
        int n = this.max + 1 - this.min;
        if (n < dBIDRange.size()) {
            LOG.warning("Distance matrix has size " + n + " but range has size: " + dBIDRange.size());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FileBasedFloatDistanceFunction fileBasedFloatDistanceFunction = (FileBasedFloatDistanceFunction)object;
        return this.cache.equals(fileBasedFloatDistanceFunction.cache);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected File matrixfile = null;
        protected DistanceParser parser = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(FileBasedDoubleDistanceFunction.Parameterizer.MATRIX_ID, FileParameter.FileType.INPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                this.matrixfile = (File)fileParameter.getValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(FileBasedDoubleDistanceFunction.Parameterizer.PARSER_ID, (Class<?>)DistanceParser.class, AsciiDistanceParser.class))) {
                this.parser = (DistanceParser)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected FileBasedFloatDistanceFunction makeInstance() {
            return new FileBasedFloatDistanceFunction(this.parser, this.matrixfile);
        }
    }
}

