/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.classification;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import java.text.NumberFormat;
import java.util.ArrayList;

public class ConfusionMatrix {
    private int[][] confusion;
    private ArrayList<ClassLabel> labels;

    public ConfusionMatrix(ArrayList<ClassLabel> arrayList, int[][] nArray) throws IllegalArgumentException {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray.length == nArray[i].length) continue;
            throw new IllegalArgumentException("Confusion matrix irregular: row-dimension = " + nArray.length + ", col-dimension in col" + i + " = " + nArray[i].length);
        }
        if (nArray.length != arrayList.size()) {
            throw new IllegalArgumentException("Number of class labels does not match row dimension of confusion matrix.");
        }
        this.confusion = nArray;
        this.labels = arrayList;
    }

    public double truePositiveRate() {
        return (double)this.truePositives() / (double)this.totalInstances();
    }

    public double falsePositiveRate(int n) {
        int n2 = this.falsePositives(n);
        int n3 = this.trueNegatives(n);
        return (double)n2 / (double)(n2 + n3);
    }

    public double falsePositiveRate() {
        double d = 0.0;
        for (int i = 0; i < this.confusion.length; ++i) {
            d += this.falsePositiveRate(i) * (double)this.colSum(i);
        }
        return d / (double)this.totalInstances();
    }

    public double positivePredictedValue(int n) {
        int n2 = this.truePositives(n);
        return (double)n2 / (double)(n2 + this.falsePositives(n));
    }

    public double positivePredictedValue() {
        double d = 0.0;
        for (int i = 0; i < this.confusion.length; ++i) {
            d += this.positivePredictedValue(i) * (double)this.colSum(i);
        }
        return d / (double)this.totalInstances();
    }

    public int truePositives() {
        int n = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            n += this.truePositives(i);
        }
        return n;
    }

    public int truePositives(int n) {
        return this.confusion[n][n];
    }

    public double truePositiveRate(int n) {
        int n2 = this.truePositives(n);
        return (double)n2 / (double)(n2 + this.falseNegatives(n));
    }

    public int trueNegatives(int n) {
        int n2 = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            for (int j = 0; j < this.confusion[i].length; ++j) {
                if (i == n || j == n) continue;
                n2 += this.confusion[i][j];
            }
        }
        return n2;
    }

    public int falsePositives(int n) {
        int n2 = 0;
        for (int i = 0; i < this.confusion[n].length; ++i) {
            if (i == n) continue;
            n2 += this.confusion[n][i];
        }
        return n2;
    }

    public int falseNegatives(int n) {
        int n2 = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            if (i == n) continue;
            n2 += this.confusion[i][n];
        }
        return n2;
    }

    public int totalInstances() {
        int n = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            for (int j = 0; j < this.confusion[i].length; ++j) {
                n += this.confusion[i][j];
            }
        }
        return n;
    }

    public int rowSum(int n) {
        int n2 = 0;
        for (int i = 0; i < this.confusion[n].length; ++i) {
            n2 += this.confusion[n][i];
        }
        return n2;
    }

    public int colSum(int n) {
        int n2 = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            n2 += this.confusion[i][n];
        }
        return n2;
    }

    public int value(int n, int n2) {
        return this.confusion[n2][n];
    }

    public String toString() {
        int n;
        int n2;
        int n3 = 0;
        for (int i = 0; i < this.confusion.length; ++i) {
            for (int j = 0; j < this.confusion[i].length; ++j) {
                if (this.confusion[i][j] <= n3) continue;
                n3 = this.confusion[i][j];
            }
        }
        String string = "C_";
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setParseIntegerOnly(true);
        int n4 = Integer.toString(this.labels.size()).length();
        numberFormat.setMaximumIntegerDigits(n4);
        numberFormat.setMinimumIntegerDigits(n4);
        int n5 = Math.max(Integer.toString(n3).length(), n4 + string.length());
        String string2 = " ";
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 1; n2 <= this.labels.size(); ++n2) {
            stringBuilder.append(string2);
            String string3 = string + numberFormat.format(n2);
            int n6 = n5 - n4 - string.length();
            for (n = 0; n <= n6; ++n) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string3);
        }
        stringBuilder.append('\n');
        for (n2 = 0; n2 < this.confusion.length; ++n2) {
            for (int i = 0; i < this.confusion[n2].length; ++i) {
                stringBuilder.append(string2);
                String string4 = Integer.toString(this.confusion[n2][i]);
                n = n5 - string4.length();
                for (int j = 0; j <= n; ++j) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string4);
            }
            stringBuilder.append(string2);
            stringBuilder.append(string);
            stringBuilder.append(numberFormat.format(n2 + 1));
            stringBuilder.append(": ");
            stringBuilder.append(this.labels.get(n2));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

