/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.classification.holdout;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.evaluation.classification.holdout.Holdout;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public abstract class AbstractHoldout
implements Holdout {
    protected ArrayList<ClassLabel> labels;
    protected int labelcol;
    protected MultipleObjectsBundle bundle;

    @Override
    public void initialize(MultipleObjectsBundle multipleObjectsBundle) {
        this.bundle = multipleObjectsBundle;
        this.labelcol = AbstractHoldout.findClassLabelColumn(multipleObjectsBundle);
        this.labels = AbstractHoldout.allClassLabels(multipleObjectsBundle);
    }

    @Override
    public ArrayList<ClassLabel> getLabels() {
        return this.labels;
    }

    public static int findClassLabelColumn(MultipleObjectsBundle multipleObjectsBundle) {
        int n = multipleObjectsBundle.metaLength();
        for (int i = 0; i < n; ++i) {
            if (!TypeUtil.CLASSLABEL.isAssignableFromType(multipleObjectsBundle.meta(i))) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList<ClassLabel> allClassLabels(MultipleObjectsBundle multipleObjectsBundle) {
        int n = AbstractHoldout.findClassLabelColumn(multipleObjectsBundle);
        if (n < 0) {
            throw new AbortException("No class label found (try using ClassLabelFilter).");
        }
        return AbstractHoldout.allClassLabels(multipleObjectsBundle, n);
    }

    public static ArrayList<ClassLabel> allClassLabels(MultipleObjectsBundle multipleObjectsBundle, int n) {
        HashSet<ClassLabel> hashSet = new HashSet<ClassLabel>();
        int n2 = multipleObjectsBundle.dataLength();
        for (int i = 0; i < n2; ++i) {
            Object object = multipleObjectsBundle.data(i, n);
            if (object == null || !(object instanceof ClassLabel)) continue;
            hashSet.add((ClassLabel)object);
        }
        ArrayList<ClassLabel> arrayList = new ArrayList<ClassLabel>(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }
}

