/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;
import java.util.List;

@Reference(authors="F. B. Baker, and L. J. Hubert", title="Measuring the Power of Hierarchical Cluster Analysis", booktitle="Journal of the American Statistical Association, 70(349)", url="http://dx.doi.org/10.1080/01621459.1975.10480256")
public class EvaluateConcordantPairs<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateConcordantPairs.class);
    private NoiseHandling noiseHandling;
    private PrimitiveDistanceFunction<? super NumberVector> distanceFunction;
    private String key = EvaluateConcordantPairs.class.getName();

    public EvaluateConcordantPairs(PrimitiveDistanceFunction<? super NumberVector> primitiveDistanceFunction, NoiseHandling noiseHandling) {
        this.distanceFunction = primitiveDistanceFunction;
        this.noiseHandling = noiseHandling;
    }

    public double evaluateClustering(Database database, Relation<? extends NumberVector> relation, Clustering<?> clustering) {
        Cluster<?> cluster2;
        List<Cluster<?>> list = clustering.getAllClusters();
        int n = 0;
        int n2 = 0;
        block4: for (Cluster<?> cluster2 : list) {
            if (cluster2.size() <= 1 || cluster2.isNoise()) {
                switch (this.noiseHandling) {
                    case IGNORE_NOISE: {
                        n += cluster2.size();
                        continue block4;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        continue block4;
                    }
                }
            }
            if ((n2 += cluster2.size() * (cluster2.size() - 1) >>> 1) >= 0) continue;
            throw new AbortException("Integer overflow - clusters too large to compute pairwise distances.");
        }
        Object object = this.computeWithinDistances(relation, list, n2);
        cluster2 = (Cluster<?>)new int[((Object)object).length];
        this.countTies((double[])object, (int[])cluster2);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < list.size(); ++i) {
            Cluster<?> cluster3 = list.get(i);
            if ((cluster3.size() <= 1 || cluster3.isNoise()) && this.noiseHandling.equals((Object)NoiseHandling.IGNORE_NOISE)) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                Cluster<?> cluster4 = list.get(j);
                if ((cluster4.size() <= 1 || cluster4.isNoise()) && this.noiseHandling.equals((Object)NoiseHandling.IGNORE_NOISE)) continue;
                l3 += (long)(cluster3.size() * cluster4.size());
                DBIDIter dBIDIter = cluster3.getIDs().iter();
                while (dBIDIter.valid()) {
                    NumberVector numberVector = relation.get(dBIDIter);
                    DBIDIter dBIDIter2 = cluster4.getIDs().iter();
                    while (dBIDIter2.valid()) {
                        double d = this.distanceFunction.distance(numberVector, relation.get(dBIDIter2));
                        int n3 = Arrays.binarySearch((double[])object, d);
                        if (n3 >= 0) {
                            while (n3 > 0 && object[n3 - 1] >= d) {
                                --n3;
                            }
                            l += (long)n3;
                            l2 += (long)(((Object)object).length - n3 - cluster2[n3]);
                        } else {
                            n3 = -n3 - 1;
                            l += (long)n3;
                            l2 += (long)(((Object)object).length - n3);
                        }
                        dBIDIter2.advance();
                    }
                    dBIDIter.advance();
                }
            }
        }
        long l4 = (long)(relation.size() - n) * (long)(relation.size() - n - 1) >>> 1;
        long l5 = l4 * (l4 - 1L) >>> 1;
        double d = (double)(l - l2) / (double)(l + l2);
        double d2 = this.computeTau(l, l2, l5, ((Object)object).length, l3);
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(this.key + ".pbm.noise-handling", this.noiseHandling.toString()));
            if (n > 0) {
                LOG.statistics(new LongStatistic(this.key + ".pbm.ignored", n));
            }
            LOG.statistics(new DoubleStatistic(this.key + ".gamma", d));
            LOG.statistics(new DoubleStatistic(this.key + ".tau", d2));
        }
        EvaluationResult evaluationResult = EvaluationResult.findOrCreate(database.getHierarchy(), clustering, "Internal Clustering Evaluation", "internal evaluation");
        EvaluationResult.MeasurementGroup measurementGroup = evaluationResult.findOrCreateGroup("Concordance-based Evaluation");
        measurementGroup.addMeasure("Gamma", d, -1.0, 1.0, 0.0, false);
        measurementGroup.addMeasure("Tau", d2, -1.0, 1.0, 0.0, false);
        database.getHierarchy().resultChanged(evaluationResult);
        return d;
    }

    protected int countTies(double[] dArray, int[] nArray) {
        int n = 0;
        int n2 = 1;
        for (int i = 1; i <= dArray.length; ++i) {
            if (i == dArray.length || dArray[i - 1] != dArray[i]) {
                for (int j = i - n2; j < i; ++j) {
                    nArray[j] = n2;
                }
                n += n2 - 1;
                n2 = 1;
                continue;
            }
            ++n2;
        }
        return n;
    }

    protected double[] computeWithinDistances(Relation<? extends NumberVector> relation, List<? extends Cluster<?>> list, int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        block4: for (Cluster<?> cluster : list) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (this.noiseHandling) {
                    case IGNORE_NOISE: {
                        continue block4;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        continue block4;
                    }
                }
            }
            DBIDIter dBIDIter = cluster.getIDs().iter();
            while (dBIDIter.valid()) {
                NumberVector numberVector = relation.get(dBIDIter);
                DBIDIter dBIDIter2 = cluster.getIDs().iter();
                while (dBIDIter2.valid()) {
                    if (DBIDUtil.compare(dBIDIter, dBIDIter2) > 0) {
                        dArray[n2++] = this.distanceFunction.distance(numberVector, relation.get(dBIDIter2));
                    }
                    dBIDIter2.advance();
                }
                dBIDIter.advance();
            }
        }
        assert (dArray.length == n2);
        Arrays.sort(dArray);
        return dArray;
    }

    @Reference(authors="F. J. Rohlf", title="Methods of comparing classifications", booktitle="Annual Review of Ecology and Systematics", url="http://dx.doi.org/10.1146/annurev.es.05.110174.000533")
    public double computeTau(long l, long l2, double d, long l3, long l4) {
        double d2 = l3 * (l3 - 1L) + l4 * (l4 - 1L) >>> 1;
        return (double)(l - l2) / Math.sqrt((d - d2) * d);
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(result);
        if (list.size() < 1) {
            return;
        }
        Database database = ResultUtil.findDatabase(resultHierarchy);
        Relation relation = database.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
        for (Clustering<? extends Model> clustering : list) {
            this.evaluateClustering(database, relation, clustering);
        }
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("concordant.distance", "Distance function to use for measuring concordant and discordant pairs.");
        public static final OptionID NOISE_ID = new OptionID("concordant-pairs.noisehandling", "Control how noise should be treated.");
        private PrimitiveDistanceFunction<NumberVector> distance;
        private NoiseHandling noiseHandling;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            EnumParameter<NoiseHandling> enumParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(DISTANCE_ID, (Class<?>)PrimitiveDistanceFunction.class, EuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (PrimitiveDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseHandling = (NoiseHandling)((Object)enumParameter.getValue());
            }
        }

        @Override
        protected EvaluateConcordantPairs<O> makeInstance() {
            return new EvaluateConcordantPairs(this.distance, this.noiseHandling);
        }
    }
}

