/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateSimplifiedSilhouette;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Iterator;
import java.util.List;

@Reference(authors="D. L. Davies and D. W. Bouldin", title="A Cluster Separation Measure", booktitle="IEEE Transactions Pattern Analysis and Machine Intelligence PAMI-1(2)", url="http://dx.doi.org/10.1109/TPAMI.1979.4766909")
public class EvaluateDaviesBouldin
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateDaviesBouldin.class);
    private NoiseHandling noiseOption;
    private NumberVectorDistanceFunction<?> distanceFunction;
    private String key = EvaluateDaviesBouldin.class.getName();

    public EvaluateDaviesBouldin(NumberVectorDistanceFunction<?> numberVectorDistanceFunction, NoiseHandling noiseHandling) {
        this.distanceFunction = numberVectorDistanceFunction;
        this.noiseOption = noiseHandling;
    }

    public double evaluateClustering(Database database, Relation<? extends NumberVector> relation, Clustering<?> clustering) {
        List<Cluster<?>> list = clustering.getAllClusters();
        NumberVector[] numberVectorArray = new NumberVector[list.size()];
        int n = EvaluateSimplifiedSilhouette.centroids(relation, list, numberVectorArray, this.noiseOption);
        double[] dArray = this.withinGroupDistances(relation, list, numberVectorArray);
        Mean mean = new Mean();
        for (int i = 0; i < list.size(); ++i) {
            NumberVector numberVector = numberVectorArray[i];
            double d = dArray[i];
            double d2 = 0.0;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                double d4;
                NumberVector numberVector2 = numberVectorArray[j];
                if (numberVector2 == numberVector) continue;
                if (numberVector != null && numberVector2 != null) {
                    d4 = this.distanceFunction.distance(numberVector, numberVector2);
                    double d5 = (d + dArray[j]) / d4;
                    d2 = d5 > d2 ? d5 : d2;
                    continue;
                }
                if (this.noiseOption == NoiseHandling.IGNORE_NOISE) continue;
                if (numberVector != null) {
                    d4 = Double.POSITIVE_INFINITY;
                    DBIDIter dBIDIter = list.get(j).getIDs().iter();
                    while (dBIDIter.valid()) {
                        d3 = this.distanceFunction.distance(numberVector, relation.get(dBIDIter));
                        d4 = d3 < d4 ? d3 : d4;
                        dBIDIter.advance();
                    }
                    d2 = (d4 = d / d4) > d2 ? d4 : d2;
                    continue;
                }
                if (numberVector2 == null) continue;
                d4 = Double.POSITIVE_INFINITY;
                DBIDIter dBIDIter = list.get(i).getIDs().iter();
                while (dBIDIter.valid()) {
                    d3 = this.distanceFunction.distance(relation.get(dBIDIter), numberVector2);
                    d4 = d3 < d4 ? d3 : d4;
                    dBIDIter.advance();
                }
                d2 = (d4 = dArray[j] / d4) > d2 ? d4 : d2;
            }
            mean.put(d2);
        }
        double d = mean.getMean();
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(this.key + ".db-index.noise-handling", this.noiseOption.toString()));
            if (n > 0) {
                LOG.statistics(new LongStatistic(this.key + ".db-index.ignored", n));
            }
            LOG.statistics(new DoubleStatistic(this.key + ".db-index", d));
        }
        EvaluationResult evaluationResult = EvaluationResult.findOrCreate(database.getHierarchy(), clustering, "Internal Clustering Evaluation", "internal evaluation");
        EvaluationResult.MeasurementGroup measurementGroup = evaluationResult.findOrCreateGroup("Distance-based Evaluation");
        measurementGroup.addMeasure("Davies Bouldin Index", d, 0.0, Double.POSITIVE_INFINITY, 0.0, true);
        database.getHierarchy().resultChanged(evaluationResult);
        return d;
    }

    public double[] withinGroupDistances(Relation<? extends NumberVector> relation, List<? extends Cluster<?>> list, NumberVector[] numberVectorArray) {
        double[] dArray = new double[list.size()];
        Iterator<Cluster<?>> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Cluster<?> cluster = iterator.next();
            NumberVector numberVector = numberVectorArray[n];
            if (numberVector == null) {
                dArray[n] = Double.NaN;
            } else {
                double d = 0.0;
                DBIDIter dBIDIter = cluster.getIDs().iter();
                while (dBIDIter.valid()) {
                    d += this.distanceFunction.distance(numberVector, relation.get(dBIDIter));
                    dBIDIter.advance();
                }
                dArray[n] = d / (double)cluster.size();
            }
            ++n;
        }
        return dArray;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(result);
        if (list.size() < 1) {
            return;
        }
        Database database = ResultUtil.findDatabase(resultHierarchy);
        Relation relation = database.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
        for (Clustering<? extends Model> clustering : list) {
            this.evaluateClustering(database, relation, clustering);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("davies-bouldin.distance", "Distance function to use for computing the davies-bouldin index.");
        public static final OptionID NOISE_ID = new OptionID("davies-bouldin.noisehandling", "Control how noise should be treated.");
        private NumberVectorDistanceFunction<?> distance;
        private NoiseHandling noiseOption;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            EnumParameter<NoiseHandling> enumParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(DISTANCE_ID, (Class<?>)NumberVectorDistanceFunction.class, EuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (NumberVectorDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)enumParameter.getValue());
            }
        }

        @Override
        protected EvaluateDaviesBouldin makeInstance() {
            return new EvaluateDaviesBouldin(this.distance, this.noiseOption);
        }
    }
}

