/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.histogram;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.result.HistogramResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractObjDynamicHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractObjStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.ObjHistogram;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleDoublePair;
import de.lmu.ifi.dbs.elki.utilities.scaling.IdentityScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

public class ComputeOutlierHistogram
implements Evaluator {
    public static final OptionID POSITIVE_CLASS_NAME_ID = new OptionID("comphist.positive", "Class label for the 'positive' class.");
    public static final OptionID BINS_ID = new OptionID("comphist.bins", "number of bins");
    public static final OptionID SCALING_ID = new OptionID("comphist.scaling", "Class to use as scaling function.");
    public static final OptionID SPLITFREQ_ID = new OptionID("histogram.splitfreq", "Use separate frequencies for outliers and non-outliers.");
    private Pattern positiveClassName = null;
    private int bins;
    private ScalingFunction scaling;
    private boolean splitfreq = false;

    public ComputeOutlierHistogram(Pattern pattern, int n, ScalingFunction scalingFunction, boolean bl) {
        this.positiveClassName = pattern;
        this.bins = n;
        this.scaling = scalingFunction;
        this.splitfreq = bl;
    }

    public HistogramResult<DoubleVector> evaluateOutlierResult(Database database, OutlierResult outlierResult) {
        double d;
        DoubleDoublePair doubleDoublePair;
        DoubleDoublePair doubleDoublePair2;
        Object object;
        if (this.scaling instanceof OutlierScalingFunction) {
            object = (OutlierScalingFunction)this.scaling;
            object.prepare(outlierResult);
        }
        object = DBIDUtil.newHashSet(outlierResult.getScores().getDBIDs());
        ArrayModifiableDBIDs arrayModifiableDBIDs = DatabaseUtil.getObjectsByLabelMatch(database, this.positiveClassName);
        double d2 = this.scaling.getMin();
        double d3 = this.scaling.getMax();
        AbstractObjStaticHistogram abstractObjStaticHistogram = Double.isInfinite(d2) || Double.isNaN(d2) || Double.isInfinite(d3) || Double.isNaN(d3) ? new AbstractObjDynamicHistogram<DoubleDoublePair>(this.bins){

            @Override
            public DoubleDoublePair aggregate(DoubleDoublePair doubleDoublePair, DoubleDoublePair doubleDoublePair2) {
                doubleDoublePair.first += doubleDoublePair2.first;
                doubleDoublePair.second += doubleDoublePair2.second;
                return doubleDoublePair;
            }

            @Override
            protected DoubleDoublePair makeObject() {
                return new DoubleDoublePair(0.0, 0.0);
            }

            @Override
            protected DoubleDoublePair cloneForCache(DoubleDoublePair doubleDoublePair) {
                return new DoubleDoublePair(doubleDoublePair.first, doubleDoublePair.second);
            }

            @Override
            protected DoubleDoublePair downsample(Object[] objectArray, int n, int n2, int n3) {
                DoubleDoublePair doubleDoublePair = new DoubleDoublePair(0.0, 0.0);
                for (int i = n; i < n2; ++i) {
                    DoubleDoublePair doubleDoublePair2 = (DoubleDoublePair)objectArray[i];
                    if (doubleDoublePair2 == null) continue;
                    doubleDoublePair.first += doubleDoublePair2.first;
                    doubleDoublePair.second += doubleDoublePair2.second;
                }
                return doubleDoublePair;
            }
        } : new AbstractObjStaticHistogram<DoubleDoublePair>(this.bins, d2, d3){

            @Override
            protected DoubleDoublePair makeObject() {
                return new DoubleDoublePair(0.0, 0.0);
            }

            @Override
            public void putData(double d, DoubleDoublePair doubleDoublePair) {
                DoubleDoublePair doubleDoublePair2 = (DoubleDoublePair)this.get(d);
                doubleDoublePair2.first += doubleDoublePair.first;
                doubleDoublePair2.second += doubleDoublePair.second;
            }
        };
        if (!this.splitfreq) {
            doubleDoublePair2 = new DoubleDoublePair(1.0 / (double)object.size(), 0.0);
            doubleDoublePair = new DoubleDoublePair(0.0, 1.0 / (double)object.size());
        } else {
            doubleDoublePair2 = new DoubleDoublePair(1.0 / (double)(object.size() - arrayModifiableDBIDs.size()), 0.0);
            doubleDoublePair = new DoubleDoublePair(0.0, 1.0 / (double)arrayModifiableDBIDs.size());
        }
        object.removeDBIDs(arrayModifiableDBIDs);
        Object object2 = object.iter();
        while (object2.valid()) {
            d = outlierResult.getScores().doubleValue((DBIDRef)object2);
            if ((d = this.scaling.getScaled(d)) > Double.NEGATIVE_INFINITY && d < Double.POSITIVE_INFINITY) {
                abstractObjStaticHistogram.putData(d, doubleDoublePair2);
            }
            object2.advance();
        }
        object2 = arrayModifiableDBIDs.iter();
        while (object2.valid()) {
            d = outlierResult.getScores().doubleValue((DBIDRef)object2);
            if ((d = this.scaling.getScaled(d)) > Double.NEGATIVE_INFINITY && d < Double.POSITIVE_INFINITY) {
                abstractObjStaticHistogram.putData(d, doubleDoublePair);
            }
            object2.advance();
        }
        object2 = new ArrayList(abstractObjStaticHistogram.getNumBins());
        ObjHistogram.Iter iter = abstractObjStaticHistogram.iter();
        while (iter.valid()) {
            DoubleDoublePair doubleDoublePair3 = (DoubleDoublePair)iter.getValue();
            DoubleVector doubleVector = new DoubleVector(new double[]{iter.getCenter(), doubleDoublePair3.first, doubleDoublePair3.second});
            object2.add(doubleVector);
            iter.advance();
        }
        return new HistogramResult<DoubleVector>("Outlier Score Histogram", "outlier-histogram", (Collection<DoubleVector>)object2);
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        Database database = ResultUtil.findDatabase(resultHierarchy);
        ArrayList<OutlierResult> arrayList = ResultUtil.filterResults(resultHierarchy, result, OutlierResult.class);
        if (arrayList == null || arrayList.size() <= 0) {
            return;
        }
        for (OutlierResult outlierResult : arrayList) {
            database.getHierarchy().add(outlierResult, this.evaluateOutlierResult(database, outlierResult));
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected Pattern positiveClassName = null;
        protected int bins;
        protected ScalingFunction scaling;
        protected boolean splitfreq = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(POSITIVE_CLASS_NAME_ID);
            patternParameter.setOptional(true);
            if (parameterization.grab(patternParameter)) {
                this.positiveClassName = (Pattern)patternParameter.getValue();
            }
            IntParameter intParameter = new IntParameter(BINS_ID, 50);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.bins = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(SCALING_ID, (Class<?>)ScalingFunction.class, IdentityScaling.class))) {
                this.scaling = (ScalingFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(flag = new Flag(SPLITFREQ_ID))) {
                this.splitfreq = (Boolean)flag.getValue();
            }
        }

        @Override
        protected ComputeOutlierHistogram makeInstance() {
            return new ComputeOutlierHistogram(this.positiveClassName, this.bins, this.scaling, this.splitfreq);
        }
    }
}

