/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.index;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialIndexTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexPurity
implements Evaluator {
    /*
     * WARNING - void declaration
     */
    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        Database database = ResultUtil.findDatabase(resultHierarchy);
        ArrayList<SpatialIndexTree> arrayList = ResultUtil.filterResults(resultHierarchy, result, SpatialIndexTree.class);
        if (arrayList == null || arrayList.size() <= 0) {
            return;
        }
        Relation<String> relation = DatabaseUtil.guessLabelRepresentation(database);
        for (SpatialIndexTree spatialIndexTree : arrayList) {
            List list = spatialIndexTree.getLeaves();
            MeanVariance meanVariance = new MeanVariance();
            for (SpatialEntry spatialEntry : list) {
                SpatialDirectoryEntry spatialDirectoryEntry = (SpatialDirectoryEntry)spatialEntry;
                Object n = spatialIndexTree.getNode(spatialDirectoryEntry.getEntryID().intValue());
                int n2 = n.getNumEntries();
                HashMap<Object, void> hashMap = new HashMap<Object, void>(n2);
                for (int i = 0; i < n2; ++i) {
                    void var19_24;
                    DBID dBID = ((SpatialPointLeafEntry)n.getEntry(i)).getDBID();
                    String string = relation.get(dBID);
                    Integer n3 = (Integer)hashMap.get(string);
                    if (n3 == null) {
                        Integer n4 = 1;
                    } else {
                        Integer n5 = n3 + 1;
                    }
                    hashMap.put(string, var19_24);
                }
                double d = 0.0;
                for (Map.Entry entry : hashMap.entrySet()) {
                    double d2 = (double)((Integer)entry.getValue()).intValue() / (double)n2;
                    d += d2 * d2;
                }
                meanVariance.put(d);
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(new DoubleVector(new double[]{meanVariance.getMean(), meanVariance.getSampleStddev()}));
            database.getHierarchy().add(spatialIndexTree, new CollectionResult("Gini coefficient of index", "index-gini", arrayList2));
        }
    }
}

