/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.outlier;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.IdentityScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import java.util.ArrayList;
import java.util.Arrays;

public class OutlierThresholdClustering
implements Evaluator {
    ScalingFunction scaling = null;
    double[] threshold;

    public OutlierThresholdClustering(ScalingFunction scalingFunction, double[] dArray) {
        this.scaling = scalingFunction;
        this.threshold = dArray;
        Arrays.sort(this.threshold);
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        ArrayList<OutlierResult> arrayList = ResultUtil.filterResults(resultHierarchy, OutlierResult.class);
        for (OutlierResult outlierResult : arrayList) {
            resultHierarchy.add(outlierResult, this.split(outlierResult));
        }
    }

    private Clustering<Model> split(OutlierResult outlierResult) {
        DoubleRelation doubleRelation = outlierResult.getScores();
        if (this.scaling instanceof OutlierScalingFunction) {
            ((OutlierScalingFunction)this.scaling).prepare(outlierResult);
        }
        ArrayList<HashSetModifiableDBIDs> arrayList = new ArrayList<HashSetModifiableDBIDs>(this.threshold.length + 1);
        for (int i = 0; i <= this.threshold.length; ++i) {
            arrayList.add(DBIDUtil.newHashSet());
        }
        Object object = doubleRelation.getDBIDs().iter();
        while (object.valid()) {
            int n;
            double d = doubleRelation.doubleValue((DBIDRef)object);
            if (this.scaling != null) {
                d = this.scaling.getScaled(d);
            }
            for (n = 0; n < this.threshold.length && !(d < this.threshold[n]); ++n) {
            }
            ((ModifiableDBIDs)arrayList.get(n)).add((DBIDRef)object);
            object.advance();
        }
        object = new Clustering("Outlier threshold clustering", "threshold-clustering");
        for (int i = 0; i <= this.threshold.length; ++i) {
            String string = i == 0 ? "Inlier" : "Outlier_" + this.threshold[i - 1];
            ((Clustering)object).addToplevelCluster(new Cluster(string, (DBIDs)arrayList.get(i), i > 0));
        }
        return object;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SCALING_ID = new OptionID("thresholdclust.scaling", "Class to use as scaling function.");
        public static final OptionID THRESHOLD_ID = new OptionID("thresholdclust.threshold", "Threshold(s) to apply.");
        ScalingFunction scaling = null;
        double[] threshold;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleListParameter doubleListParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(SCALING_ID, (Class<?>)ScalingFunction.class, IdentityScaling.class);
            if (parameterization.grab(objectParameter)) {
                this.scaling = (ScalingFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(doubleListParameter = new DoubleListParameter(THRESHOLD_ID))) {
                this.threshold = (double[])((double[])doubleListParameter.getValue()).clone();
            }
        }

        @Override
        protected OutlierThresholdClustering makeInstance() {
            return new OutlierThresholdClustering(this.scaling, this.threshold);
        }
    }
}

