/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.configurator;

import de.lmu.ifi.dbs.elki.gui.configurator.AbstractSingleParameterConfigurator;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class EnumParameterConfigurator
extends AbstractSingleParameterConfigurator<EnumParameter<?>>
implements ActionListener {
    final JComboBox<String> value;

    public EnumParameterConfigurator(EnumParameter<?> enumParameter, JComponent jComponent) {
        super(enumParameter, jComponent);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.value = new JComboBox();
        this.value.setToolTipText(((EnumParameter)this.param).getShortDescription());
        this.value.setPrototypeDisplayValue(enumParameter.getPossibleValues().iterator().next());
        jComponent.add(this.value, gridBagConstraints);
        this.finishGridRow();
        if (!((EnumParameter)this.param).tookDefaultValue() && ((EnumParameter)this.param).isDefined() && ((EnumParameter)this.param).getGivenValue() != null) {
            this.value.addItem(((EnumParameter)this.param).getValueAsString());
            this.value.setSelectedIndex(0);
        }
        if (enumParameter.hasDefaultValue()) {
            this.value.addItem("Default: " + enumParameter.getDefaultValueAsString());
        } else if (enumParameter.isOptional()) {
            this.value.addItem("(optional)");
        }
        for (String string : enumParameter.getPossibleValues()) {
            this.value.addItem(string);
        }
        this.value.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.value) {
            this.fireValueChanged();
        } else {
            LoggingUtil.warning("actionPerformed triggered by unknown source: " + actionEvent.getSource());
        }
    }

    @Override
    public String getUserInput() {
        String string = (String)this.value.getSelectedItem();
        if (string.startsWith("Default: ")) {
            return null;
        }
        if ("(optional)".equals(string)) {
            return null;
        }
        return string;
    }
}

