/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import java.util.ArrayList;

public class DynamicParameters {
    public static final int BIT_INCOMPLETE = 1;
    public static final int BIT_INVALID = 2;
    public static final int BIT_SYNTAX_ERROR = 4;
    public static final int BIT_OPTIONAL = 8;
    public static final int BIT_DEFAULT_VALUE = 16;
    public static final String STRING_USE_DEFAULT = "Default: ";
    public static final String STRING_OPTIONAL = "(optional)";
    protected ArrayList<Node> parameters = new ArrayList();
    protected static OptionID REMAINING_OPTIONS_ID = new OptionID("UNUSED", "Unrecognized options.");

    public int size() {
        return this.parameters.size();
    }

    public synchronized void updateFromTrackParameters(TrackParameters trackParameters) {
        this.parameters.clear();
        for (TrackedParameter trackedParameter : trackParameters.getAllParameters()) {
            Parameter<?> parameter = trackedParameter.getParameter();
            String string = null;
            if (parameter.isDefined()) {
                string = parameter.tookDefaultValue() ? STRING_USE_DEFAULT + parameter.getDefaultValueAsString() : parameter.getValueAsString();
            }
            if (string == null) {
                string = parameter instanceof Flag ? "false" : "";
            }
            int n = 0;
            if (parameter.isOptional()) {
                n |= 8;
            }
            if (parameter.hasDefaultValue() && parameter.tookDefaultValue()) {
                n |= 0x10;
            }
            if (string.length() <= 0) {
                if ((n & 0x10) == 0 && (n & 8) == 0) {
                    n |= 1;
                }
            } else {
                try {
                    if (!parameter.tookDefaultValue() && !parameter.isValid(string)) {
                        n |= 2;
                    }
                }
                catch (ParameterException parameterException) {
                    n |= 2;
                }
            }
            int n2 = 0;
            Object object = trackParameters.getParent(parameter);
            while (object != null) {
                object = trackParameters.getParent(object);
                if (++n2 <= 10) continue;
            }
            this.parameters.add(new Node(parameter, string, n, n2));
        }
    }

    public synchronized void addParameter(Parameter<?> parameter, String string, int n, int n2) {
        this.parameters.add(new Node(parameter, string, n, n2));
    }

    public synchronized void serializeParameters(ArrayList<String> arrayList) {
        for (Node node : this.parameters) {
            if (node.param == null) continue;
            if (node.param instanceof RemainingOptions) {
                for (String string : node.value.split(" ")) {
                    if (string.length() <= 0) continue;
                    arrayList.add(string);
                }
                continue;
            }
            if (node.param instanceof Flag) {
                if (!"true".equals(node.value)) continue;
                arrayList.add("-" + node.param.getOptionID().getName());
                continue;
            }
            if (node.value == null || node.value.length() <= 0 || node.value.startsWith(STRING_USE_DEFAULT) || STRING_OPTIONAL.equals(node.value)) continue;
            arrayList.add("-" + node.param.getOptionID().getName());
            arrayList.add(node.value);
        }
    }

    public Node getNode(int n) {
        return this.parameters.get(n);
    }

    public static class RemainingOptions
    extends StringParameter {
        public RemainingOptions() {
            super(REMAINING_OPTIONS_ID);
            super.setOptional(true);
        }
    }

    public class Node {
        protected Parameter<?> param;
        protected String value;
        protected int flags;
        protected int depth;

        public Node(Parameter<?> parameter, String string, int n, int n2) {
            this.param = parameter;
            this.value = string;
            this.flags = n;
            this.depth = n2;
        }
    }
}

