/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.Node;
import de.lmu.ifi.dbs.elki.index.tree.metrical.MetricalIndexTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.List;

@Title(value="Spatial Approximation Materialize kNN Preprocessor")
@Description(value="Caterializes the (approximate) k nearest neighbors of objects of a database using a spatial approximation.")
public class MetricalIndexApproximationMaterializeKNNPreprocessor<O extends NumberVector, N extends Node<E>, E extends MTreeEntry>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(MetricalIndexApproximationMaterializeKNNPreprocessor.class);

    public MetricalIndexApproximationMaterializeKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int n) {
        super(relation, distanceFunction, n);
    }

    @Override
    protected void preprocess() {
        DistanceQuery distanceQuery = this.relation.getDistanceQuery(this.distanceFunction, new Object[0]);
        MetricalIndexTree<O, N, MTreeEntry> metricalIndexTree = this.getMetricalIndex(this.relation);
        this.createStorage();
        MeanVariance meanVariance = new MeanVariance();
        MeanVariance meanVariance2 = new MeanVariance();
        if (this.getLogger().isVerbose()) {
            this.getLogger().verbose("Approximating nearest neighbor lists to database objects");
        }
        List<E> list = metricalIndexTree.getLeaves();
        FiniteProgress finiteProgress = this.getLogger().isVerbose() ? new FiniteProgress("Processing leaf nodes", list.size(), this.getLogger()) : null;
        for (MTreeEntry mTreeEntry : list) {
            Object n = metricalIndexTree.getNode(mTreeEntry);
            int n2 = n.getNumEntries();
            meanVariance.put(n2);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest("NumEntires = " + n2);
            }
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(n2);
            for (int i = 0; i < n2; ++i) {
                arrayModifiableDBIDs.add(((LeafEntry)n.getEntry(i)).getDBID());
            }
            TObjectDoubleHashMap<DBIDPair> tObjectDoubleHashMap = new TObjectDoubleHashMap<DBIDPair>(n2 * n2 * 3 >> 2, 0.5f, Double.NaN);
            DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
            while (dBIDArrayMIter.valid()) {
                KNNHeap kNNHeap = DBIDUtil.newHeap(this.k);
                DBIDArrayMIter dBIDArrayMIter2 = arrayModifiableDBIDs.iter();
                while (dBIDArrayMIter2.valid()) {
                    DBIDPair dBIDPair = DBIDUtil.newPair(dBIDArrayMIter, (DBIDRef)dBIDArrayMIter2);
                    double d = tObjectDoubleHashMap.remove(dBIDPair);
                    if (d == d) {
                        kNNHeap.insert(d, dBIDArrayMIter2);
                    } else {
                        d = distanceQuery.distance((DBIDRef)dBIDArrayMIter, (DBIDRef)dBIDArrayMIter2);
                        kNNHeap.insert(d, dBIDArrayMIter2);
                        dBIDPair = DBIDUtil.newPair(dBIDArrayMIter2, (DBIDRef)dBIDArrayMIter);
                        tObjectDoubleHashMap.put(dBIDPair, d);
                    }
                    dBIDArrayMIter2.advance();
                }
                meanVariance2.put(kNNHeap.size());
                this.storage.put(dBIDArrayMIter, kNNHeap.toKNNList());
                dBIDArrayMIter.advance();
            }
            if (this.getLogger().isDebugging() && tObjectDoubleHashMap.size() > 0) {
                this.getLogger().warning("Cache should be empty after each run, but still has " + tObjectDoubleHashMap.size() + " elements.");
            }
            this.getLogger().incrementProcessed(finiteProgress);
        }
        this.getLogger().ensureCompleted(finiteProgress);
        if (this.getLogger().isVerbose()) {
            this.getLogger().verbose("Average page size = " + meanVariance.getMean() + " +- " + meanVariance.getSampleStddev());
            this.getLogger().verbose("On average, " + meanVariance2.getMean() + " +- " + meanVariance2.getSampleStddev() + " neighbors returned.");
        }
    }

    private MetricalIndexTree<O, N, E> getMetricalIndex(Relation<O> relation) throws IllegalStateException {
        Class clazz = ClassGenericsUtil.uglyCastIntoSubclass(MetricalIndexTree.class);
        ArrayList arrayList = ResultUtil.filterResults(relation.getHierarchy(), relation, clazz);
        if (arrayList.size() == 1) {
            return (MetricalIndexTree)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            throw new IllegalStateException("More than one metrical index found - this is not supported!");
        }
        throw new IllegalStateException("No metrical index found!");
    }

    @Override
    public String getLongName() {
        return "Metrical index knn approximation";
    }

    @Override
    public String getShortName() {
        return "metrical-knn-approximation";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<O extends NumberVector, N extends Node<E>, E extends MTreeEntry>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        public Factory(int n, DistanceFunction<? super O> distanceFunction) {
            super(n, distanceFunction);
        }

        @Override
        public MetricalIndexApproximationMaterializeKNNPreprocessor<O, N, E> instantiate(Relation<O> relation) {
            MetricalIndexApproximationMaterializeKNNPreprocessor metricalIndexApproximationMaterializeKNNPreprocessor = new MetricalIndexApproximationMaterializeKNNPreprocessor(relation, this.distanceFunction, this.k);
            return metricalIndexApproximationMaterializeKNNPreprocessor;
        }

        public static class Parameterizer<O extends NumberVector, N extends Node<E>, E extends MTreeEntry>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            @Override
            protected Factory<O, N, E> makeInstance() {
                return new Factory(this.k, this.distanceFunction);
            }
        }
    }
}

