/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPair;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.AbstractSpatialSorter;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.SpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

@Reference(authors="E. Schubert, A. Zimek, H.-P. Kriegel", title="Fast and Scalable Outlier Detection with Approximate Nearest Neighbor Ensembles", booktitle="Proc. 20th International Conference on Database Systems for Advanced Applications (DASFAA)", url="http://dx.doi.org/10.1007/978-3-319-18123-3_2")
public class SpacefillingKNNPreprocessor<O extends NumberVector>
extends AbstractIndex<O>
implements KNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(SpacefillingKNNPreprocessor.class);
    final List<SpatialSorter> curvegen;
    final double window;
    final int variants;
    List<List<SpatialPair<DBID, NumberVector>>> curves = null;
    WritableDataStore<int[]> positions = null;
    Mean mean = new Mean();
    final int odim;
    RandomProjectionFamily proj;
    Random random;

    public SpacefillingKNNPreprocessor(Relation<O> relation, List<SpatialSorter> list, double d, int n, int n2, RandomProjectionFamily randomProjectionFamily, Random random) {
        super(relation);
        this.curvegen = list;
        this.window = d;
        this.variants = n;
        this.odim = n2;
        this.proj = randomProjectionFamily;
        this.random = random;
    }

    @Override
    public void initialize() {
        if (this.curves != null) {
            throw new UnsupportedOperationException("Preprocessor already ran.");
        }
        if (this.relation.size() > 0) {
            this.preprocess();
        }
    }

    protected void preprocess() {
        int n;
        int n2;
        Object object;
        Object object2;
        int n3;
        SpatialPair<DBID, NumberVector> spatialPair;
        Object object3;
        int n4;
        long l = System.currentTimeMillis();
        int n5 = this.relation.size();
        int n6 = this.curvegen.size();
        int n7 = this.variants;
        this.curves = new ArrayList<List<SpatialPair<DBID, NumberVector>>>(n7);
        for (n4 = 0; n4 < n7; ++n4) {
            this.curves.add(new ArrayList(n5));
        }
        if (this.proj == null) {
            Object object4 = this.relation.iterDBIDs();
            while (object4.valid()) {
                NumberVector numberVector = (NumberVector)this.relation.get((DBIDRef)object4);
                object3 = new SpatialPair<DBID, NumberVector>(DBIDUtil.deref((DBIDRef)object4), numberVector);
                for (List<SpatialPair<DBID, NumberVector>> list : this.curves) {
                    list.add((SpatialPair<DBID, NumberVector>)object3);
                }
                object4.advance();
            }
            object4 = AbstractSpatialSorter.computeMinMax(this.curves.get(0));
            double d = 0.0;
            for (int i = 0; i < ((Object)object4).length; i += 2) {
                d = Math.max(d, (double)(object4[i + 1] - object4[i]));
            }
            spatialPair = (SpatialPair<DBID, NumberVector>)new double[((Object)object4).length];
            int n8 = ((Object)object4).length >>> 1;
            n3 = this.odim < 0 ? n8 : Math.min(this.odim, n8);
            object2 = SpacefillingKNNPreprocessor.range(0, n8);
            object = n3 != n8 ? (Object)new int[n3] : object2;
            for (n2 = 0; n2 < n7; ++n2) {
                int n9 = n6 > 1 ? this.random.nextInt(n6) : 0;
                double d2 = 1.0 + this.random.nextDouble();
                for (n = 0; n < ((Object)object4).length; n += 2) {
                    spatialPair[n] = object4[n] - d * this.random.nextDouble();
                    spatialPair[n + 1] = spatialPair[n] + d * d2;
                }
                SpacefillingKNNPreprocessor.randomPermutation((int[])object2, this.random);
                System.arraycopy(object2, 0, object, 0, n3);
                this.curvegen.get(n9).sort(this.curves.get(n2), 0, n5, (double[])spatialPair, (int[])object);
            }
        } else {
            n4 = RelationUtil.dimensionality(this.relation);
            int n10 = this.odim < 0 ? n4 : this.odim;
            object3 = SpacefillingKNNPreprocessor.range(0, n10);
            spatialPair = RelationUtil.getNumberVectorFactory(this.relation);
            double[] dArray = new double[this.odim << 1];
            for (n3 = 0; n3 < n7; ++n3) {
                int n11;
                object2 = this.curves.get(n3);
                object = this.proj.generateProjection(n4, n10);
                n2 = n6 > 1 ? this.random.nextInt(n6) : 0;
                for (int i = 0; i < dArray.length; i += 2) {
                    dArray[i] = Double.POSITIVE_INFINITY;
                    dArray[i + 1] = Double.NEGATIVE_INFINITY;
                }
                DBIDIter dBIDIter = this.relation.iterDBIDs();
                while (dBIDIter.valid()) {
                    double[] dArray2 = object.project((NumberVector)this.relation.get(dBIDIter));
                    object2.add(new SpatialPair(DBIDUtil.deref(dBIDIter), spatialPair.newNumberVector(dArray2)));
                    n11 = 0;
                    n = 0;
                    while (n11 < dArray.length) {
                        dArray[n11] = Math.min(dArray[n11], dArray2[n]);
                        dArray[n11 + 1] = Math.max(dArray[n11 + 1], dArray2[n]);
                        n11 += 2;
                        ++n;
                    }
                    dBIDIter.advance();
                }
                double d = 0.0;
                for (n11 = 0; n11 < dArray.length; n11 += 2) {
                    d = Math.max(d, dArray[n11 + 1] - dArray[n11]);
                }
                double d3 = 1.0 + this.random.nextDouble();
                for (int i = 0; i < dArray.length; i += 2) {
                    int n12 = i;
                    dArray[n12] = dArray[n12] - d * this.random.nextDouble();
                    dArray[i + 1] = dArray[i] + d * d3;
                }
                SpacefillingKNNPreprocessor.randomPermutation(object3, this.random);
                this.curvegen.get(n2).sort(object2, 0, n5, dArray, (int[])object3);
            }
        }
        this.positions = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, int[].class);
        for (int i = 0; i < n7; ++i) {
            Iterator<SpatialPair<DBID, NumberVector>> iterator = this.curves.get(i).iterator();
            int n13 = 0;
            while (iterator.hasNext()) {
                int[] nArray;
                spatialPair = iterator.next();
                if (i == 0) {
                    nArray = new int[n7];
                    this.positions.put((DBIDRef)spatialPair.first, nArray);
                } else {
                    nArray = (int[])this.positions.get((DBIDRef)spatialPair.first);
                }
                nArray[i] = n13++;
            }
        }
        long l2 = System.currentTimeMillis();
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.getClass().getCanonicalName() + ".construction-time.ms", l2 - l));
        }
    }

    public static int[] range(int n, int n2) {
        int[] nArray = new int[n2 - n];
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            nArray[n3] = n4++;
            ++n3;
        }
        return nArray;
    }

    public static int[] randomPermutation(int[] nArray, Random random) {
        for (int i = nArray.length - 1; i > 0; --i) {
            int n = random.nextInt(i + 1);
            int n2 = nArray[n];
            nArray[n] = nArray[i];
            nArray[i] = n2;
        }
        return nArray;
    }

    @Override
    public String getLongName() {
        return "Space Filling Curve KNN preprocessor";
    }

    @Override
    public String getShortName() {
        return "spacefilling-knn";
    }

    @Override
    public void logStatistics() {
        LOG.statistics(new DoubleStatistic(this.getClass().getCanonicalName() + ".distance-computations-per-k", this.mean.getMean()));
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        for (Object object : objectArray) {
            if (!"exact".equals(object)) continue;
            return null;
        }
        return new SpaceFillingKNNQuery(distanceQuery);
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V, SpacefillingKNNPreprocessor<V>> {
        List<SpatialSorter> curvegen;
        double window;
        int variants;
        int odim;
        RandomProjectionFamily proj;
        RandomFactory random;

        public Factory(List<SpatialSorter> list, double d, int n, int n2, RandomProjectionFamily randomProjectionFamily, RandomFactory randomFactory) {
            this.curvegen = list;
            this.window = d;
            this.variants = n;
            this.odim = n2;
            this.proj = randomProjectionFamily;
            this.random = randomFactory;
        }

        @Override
        public SpacefillingKNNPreprocessor<V> instantiate(Relation<V> relation) {
            return new SpacefillingKNNPreprocessor<V>(relation, this.curvegen, this.window, this.variants, this.odim, this.proj, this.random.getRandom());
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            public static final OptionID CURVES_ID = new OptionID("sfcknn.curves", "Space filling curve generators to use for kNN approximation.");
            public static final OptionID WINDOW_ID = new OptionID("sfcknn.windowmult", "Window size multiplicator.");
            public static final OptionID VARIANTS_ID = new OptionID("sfcknn.variants", "Number of curve variants to generate.");
            public static final OptionID DIM_ID = new OptionID("sfcknn.dim", "Number of dimensions to use for each curve.");
            public static final OptionID PROJECTION_ID = new OptionID("sfcknn.proj", "Random projection to use.");
            public static final OptionID RANDOM_ID = new OptionID("sfcknn.seed", "Random generator.");
            List<SpatialSorter> curvegen;
            double window;
            int variants;
            int odim = -1;
            RandomProjectionFamily proj;
            RandomFactory random;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                RandomParameter randomParameter;
                DoubleParameter doubleParameter;
                super.makeOptions(parameterization);
                ObjectListParameter objectListParameter = new ObjectListParameter(CURVES_ID, SpatialSorter.class);
                if (parameterization.grab(objectListParameter)) {
                    this.curvegen = objectListParameter.instantiateClasses(parameterization);
                }
                if (parameterization.grab(doubleParameter = new DoubleParameter(WINDOW_ID, 10.0))) {
                    this.window = (Double)doubleParameter.getValue();
                }
                IntParameter intParameter = new IntParameter(VARIANTS_ID, 1);
                intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.variants = (Integer)intParameter.getValue();
                }
                IntParameter intParameter2 = new IntParameter(DIM_ID);
                intParameter2.setOptional(true);
                intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter2)) {
                    this.odim = intParameter2.intValue();
                }
                ObjectParameter objectParameter = new ObjectParameter(PROJECTION_ID, RandomProjectionFamily.class);
                objectParameter.setOptional(true);
                if (parameterization.grab(objectParameter)) {
                    this.proj = (RandomProjectionFamily)objectParameter.instantiateClass(parameterization);
                }
                if (parameterization.grab(randomParameter = new RandomParameter(RANDOM_ID))) {
                    this.random = (RandomFactory)randomParameter.getValue();
                }
            }

            @Override
            protected Factory<?> makeInstance() {
                return new Factory(this.curvegen, this.window, this.variants, this.odim, this.proj, this.random);
            }
        }
    }

    protected class SpaceFillingKNNQuery
    implements KNNQuery<O> {
        DistanceQuery<O> distq;

        public SpaceFillingKNNQuery(DistanceQuery<O> distanceQuery) {
            this.distq = distanceQuery;
        }

        @Override
        public KNNList getKNNForDBID(DBIDRef dBIDRef, int n) {
            Object object;
            int n2;
            int n3 = (int)Math.ceil(SpacefillingKNNPreprocessor.this.window * (double)n);
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(2 * n3 * SpacefillingKNNPreprocessor.this.curves.size());
            int[] nArray = (int[])SpacefillingKNNPreprocessor.this.positions.get(dBIDRef);
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object = SpacefillingKNNPreprocessor.this.curves.get(n2);
                int n4 = Math.max(0, nArray[n2] - n3);
                int n5 = Math.min(nArray[n2] + n3 + 1, object.size());
                for (int i = n4; i < n5; ++i) {
                    hashSetModifiableDBIDs.add((DBIDRef)((SpatialPair)object.get((int)i)).first);
                }
            }
            n2 = 0;
            object = DBIDUtil.newHeap(n);
            NumberVector numberVector = (NumberVector)SpacefillingKNNPreprocessor.this.relation.get(dBIDRef);
            DBIDMIter dBIDMIter = hashSetModifiableDBIDs.iter();
            while (dBIDMIter.valid()) {
                object.insert(this.distq.distance((DBIDMIter)((Object)numberVector), dBIDMIter), dBIDMIter);
                ++n2;
                dBIDMIter.advance();
            }
            SpacefillingKNNPreprocessor.this.mean.put((double)n2 / (double)n);
            return object.toKNNList();
        }

        @Override
        public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
            throw new AbortException("Not yet implemented");
        }

        @Override
        public KNNList getKNNForObject(O o, int n) {
            throw new AbortException("Not yet implemented");
        }
    }
}

