/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.index.tree.AbstractDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MTreeDirectoryEntry
extends AbstractDirectoryEntry
implements MTreeEntry {
    private static final long serialVersionUID = 2L;
    private DBID routingObjectID;
    private double parentDistance;
    private double coveringRadius;

    public MTreeDirectoryEntry() {
    }

    public MTreeDirectoryEntry(DBID dBID, double d, Integer n, double d2) {
        super(n);
        this.routingObjectID = dBID;
        this.parentDistance = d;
        this.coveringRadius = d2;
    }

    @Override
    public final double getCoveringRadius() {
        return this.coveringRadius;
    }

    @Override
    public final boolean setCoveringRadius(double d) {
        if (this.coveringRadius == d) {
            return false;
        }
        this.coveringRadius = d;
        return true;
    }

    @Override
    public final DBID getRoutingObjectID() {
        return this.routingObjectID;
    }

    @Override
    public final boolean setRoutingObjectID(DBID dBID) {
        if (dBID == this.routingObjectID || DBIDUtil.equal(dBID, this.routingObjectID)) {
            return false;
        }
        this.routingObjectID = dBID;
        return true;
    }

    @Override
    public final double getParentDistance() {
        return this.parentDistance;
    }

    @Override
    public final boolean setParentDistance(double d) {
        if (this.parentDistance == d) {
            return false;
        }
        this.parentDistance = d;
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(DBIDUtil.asInteger(this.routingObjectID));
        objectOutput.writeDouble(this.parentDistance);
        objectOutput.writeDouble(this.coveringRadius);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.routingObjectID = DBIDUtil.importInteger(objectInput.readInt());
        this.parentDistance = objectInput.readDouble();
        this.coveringRadius = objectInput.readDouble();
    }

    @Override
    public String toString() {
        return super.toString() + " (o.id = " + this.getRoutingObjectID() + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MTreeDirectoryEntry mTreeDirectoryEntry = (MTreeDirectoryEntry)object;
        if (Math.abs(this.coveringRadius - mTreeDirectoryEntry.coveringRadius) < Double.MIN_NORMAL) {
            return false;
        }
        if (Math.abs(this.parentDistance - mTreeDirectoryEntry.parentDistance) < Double.MIN_NORMAL) {
            return false;
        }
        return !(this.routingObjectID == null ? mTreeDirectoryEntry.routingObjectID != null : !DBIDUtil.equal(this.routingObjectID, mTreeDirectoryEntry.routingObjectID));
    }
}

