/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.ApproximationLine;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPTree;

class MkCoPTreeNode<O>
extends AbstractMTreeNode<O, MkCoPTreeNode<O>, MkCoPEntry> {
    private static final long serialVersionUID = 1L;

    public MkCoPTreeNode() {
    }

    public MkCoPTreeNode(int n, boolean bl) {
        super(n, bl, MkCoPEntry.class);
    }

    protected ApproximationLine conservativeKnnDistanceApproximation(int n) {
        ApproximationLine approximationLine;
        MkCoPEntry mkCoPEntry;
        int n2;
        int n3 = n;
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (n2 = 0; n2 < this.getNumEntries(); ++n2) {
            mkCoPEntry = (MkCoPEntry)this.getEntry(n2);
            approximationLine = mkCoPEntry.getConservativeKnnDistanceApproximation();
            n3 = Math.min(approximationLine.getK_0(), n3);
        }
        for (n2 = 0; n2 < this.getNumEntries(); ++n2) {
            mkCoPEntry = (MkCoPEntry)this.getEntry(n2);
            approximationLine = mkCoPEntry.getConservativeKnnDistanceApproximation();
            double d3 = approximationLine.getValueAt(n3);
            double d4 = approximationLine.getValueAt(n);
            if (!Double.isInfinite(d3)) {
                d = Math.max(d3, d);
            }
            if (Double.isInfinite(d4)) continue;
            d2 = Math.max(d4, d2);
        }
        double d5 = (d2 - d) / (Math.log(n) - Math.log(n3));
        double d6 = d - d5 * Math.log(n3);
        return new ApproximationLine(n3, d5, d6);
    }

    protected ApproximationLine progressiveKnnDistanceApproximation(int n) {
        ApproximationLine approximationLine;
        MkCoPLeafEntry mkCoPLeafEntry;
        int n2;
        if (!this.isLeaf()) {
            throw new UnsupportedOperationException("Progressive KNN-distance approximation is only vailable in leaf nodes!");
        }
        int n3 = 0;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        for (n2 = 0; n2 < this.getNumEntries(); ++n2) {
            mkCoPLeafEntry = (MkCoPLeafEntry)this.getEntry(n2);
            approximationLine = mkCoPLeafEntry.getProgressiveKnnDistanceApproximation();
            n3 = Math.max(approximationLine.getK_0(), n3);
        }
        for (n2 = 0; n2 < this.getNumEntries(); ++n2) {
            mkCoPLeafEntry = (MkCoPLeafEntry)this.getEntry(n2);
            approximationLine = mkCoPLeafEntry.getProgressiveKnnDistanceApproximation();
            d = Math.min(approximationLine.getValueAt(n3), d);
            d2 = Math.min(approximationLine.getValueAt(n), d2);
        }
        double d3 = (d2 - d) / (Math.log(n) - Math.log(n3));
        double d4 = d - d3 * Math.log(n3);
        return new ApproximationLine(n3, d3, d4);
    }

    @Override
    public boolean adjustEntry(MkCoPEntry mkCoPEntry, DBID dBID, double d, AbstractMTree<O, MkCoPTreeNode<O>, MkCoPEntry, ?> abstractMTree) {
        super.adjustEntry(mkCoPEntry, dBID, d, abstractMTree);
        return true;
    }

    @Override
    protected void integrityCheckParameters(MkCoPEntry mkCoPEntry, MkCoPTreeNode<O> mkCoPTreeNode, int n, AbstractMTree<O, MkCoPTreeNode<O>, MkCoPEntry, ?> abstractMTree) {
        super.integrityCheckParameters(mkCoPEntry, mkCoPTreeNode, n, abstractMTree);
        MkCoPEntry mkCoPEntry2 = (MkCoPEntry)mkCoPTreeNode.getEntry(n);
        int n2 = ((MkCoPTree)abstractMTree).getK_max();
        ApproximationLine approximationLine = this.conservativeKnnDistanceApproximation(n2);
        if (!mkCoPEntry2.getConservativeKnnDistanceApproximation().equals(approximationLine)) {
            String string = approximationLine.toString();
            String string2 = mkCoPEntry2.getConservativeKnnDistanceApproximation().toString();
            throw new RuntimeException("Wrong conservative approximation in node " + mkCoPTreeNode.getPageID() + " at index " + n + " (child " + mkCoPEntry2 + ")" + "\nsoll: " + string + ",\n ist: " + string2);
        }
    }
}

