/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.insert;

import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.insert.MTreeInsert;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="VLDB'97, Proceedings of 23rd International Conference on Very Large Data Bases, August 25-29, 1997, Athens, Greece", url="http://www.vldb.org/conf/1997/P426.PDF")
public class MinimumEnlargementInsert<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry>
implements MTreeInsert<O, N, E> {
    @Override
    public IndexTreePath<E> choosePath(AbstractMTree<O, N, E, ?> abstractMTree, E e) {
        return this.choosePath(abstractMTree, e, abstractMTree.getRootPath());
    }

    private IndexTreePath<E> choosePath(AbstractMTree<O, N, E, ?> abstractMTree, E e, IndexTreePath<E> indexTreePath) {
        AbstractMTreeNode abstractMTreeNode = (AbstractMTreeNode)abstractMTree.getNode(indexTreePath.getEntry());
        if (abstractMTreeNode.isLeaf()) {
            return indexTreePath;
        }
        int n = 0;
        MTreeEntry mTreeEntry = (MTreeEntry)abstractMTreeNode.getEntry(0);
        double d = abstractMTree.distance(e.getRoutingObjectID(), mTreeEntry.getRoutingObjectID());
        for (int i = 1; i < abstractMTreeNode.getNumEntries(); ++i) {
            MTreeEntry mTreeEntry2 = (MTreeEntry)abstractMTreeNode.getEntry(i);
            double d2 = abstractMTree.distance(e.getRoutingObjectID(), mTreeEntry2.getRoutingObjectID());
            if (!(d2 < d)) continue;
            n = i;
            mTreeEntry = mTreeEntry2;
            d = d2;
        }
        return this.choosePath(abstractMTree, e, new IndexTreePath<MTreeEntry>(indexTreePath, mTreeEntry, n));
    }
}

