/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split;

import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.Assignments;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.MTreeSplit;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="VLDB'97, Proceedings of 23rd International Conference on Very Large Data Bases, August 25-29, 1997, Athens, Greece", url="http://www.vldb.org/conf/1997/P426.PDF")
@Alias(value={"de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.split.MLBDistSplit"})
public class MLBDistSplit<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry>
extends MTreeSplit<O, N, E> {
    @Override
    public Assignments<E> split(AbstractMTree<O, N, E, ?> abstractMTree, N n) {
        int n2 = ((AbstractNode)n).getNumEntries();
        double[] dArray = this.computeDistanceMatrix(abstractMTree, n);
        int n3 = -1;
        int n4 = -1;
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n2; ++i) {
            int n5 = i * n2;
            for (int j = i + 1; j < n2; ++j) {
                double d2 = dArray[n5 + j];
                if (!(d2 > d)) continue;
                n3 = i;
                n4 = j;
                d = d2;
            }
        }
        return this.balancedPartition(abstractMTree, n, n3, n4, dArray);
    }
}

