/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.bulk;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialSingleMeanComparator;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.bulk.AbstractBulkSplit;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;
import java.util.List;

@Reference(authors="Leutenegger, S.T. and Lopez, M.A. and Edgington, J.", title="STR: A simple and efficient algorithm for R-tree packing", booktitle="Proc. 13th International Conference on Data Engineering, 1997", url="http://dx.doi.org/10.1109/ICDE.1997.582015")
@Alias(value={"str", "STR"})
public class SortTileRecursiveBulkSplit
extends AbstractBulkSplit {
    public static final SortTileRecursiveBulkSplit STATIC = new SortTileRecursiveBulkSplit();

    @Override
    public <T extends SpatialComparable> List<List<T>> partition(List<T> list, int n, int n2) {
        int n3 = ((SpatialComparable)list.get(0)).getDimensionality();
        int n4 = (int)Math.ceil((double)list.size() / (double)n2);
        ArrayList<List<T>> arrayList = new ArrayList<List<T>>(n4);
        this.strPartition(list, 0, list.size(), 0, n3, n2, new SpatialSingleMeanComparator(0), arrayList);
        return arrayList;
    }

    protected <T extends SpatialComparable> void strPartition(List<T> list, int n, int n2, int n3, int n4, int n5, SpatialSingleMeanComparator spatialSingleMeanComparator, List<List<T>> list2) {
        int n6 = (int)Math.ceil((double)(n2 - n) / (double)n5);
        int n7 = (int)Math.ceil(Math.pow(n6, 1.0 / (double)(n4 - n3)));
        double d = n2 - n;
        for (int i = 0; i < n7; ++i) {
            int n8 = n + (int)((double)i * d / (double)n7);
            int n9 = n + (int)((double)(i + 1) * d / (double)n7);
            if (n9 < n2) {
                spatialSingleMeanComparator.setDimension(n3);
                QuickSelect.quickSelect(list, spatialSingleMeanComparator, n8, n2, n9);
            }
            if (n3 + 1 == n4) {
                list2.add(list.subList(n8, n9));
                continue;
            }
            this.strPartition(list, n8, n9, n3 + 1, n4, n5, spatialSingleMeanComparator, list2);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SortTileRecursiveBulkSplit makeInstance() {
            return STATIC;
        }
    }
}

