/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geodesy;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="Ed Williams", title="Aviation Formulary", booktitle="", url="http://williams.best.vwh.net/avform.htm")
public final class SphereUtil {
    private static final int MAX_ITER = 20;
    private static final double PRECISION = 1.0E-12;
    private static final double ONE_SIXTH = 0.16666666666666666;

    private SphereUtil() {
    }

    public static double cosineFormulaDeg(double d, double d2, double d3, double d4) {
        return SphereUtil.cosineFormulaRad(MathUtil.deg2rad(d), MathUtil.deg2rad(d2), MathUtil.deg2rad(d3), MathUtil.deg2rad(d4));
    }

    public static double cosineFormulaRad(double d, double d2, double d3, double d4) {
        double d5 = Math.sin(d);
        double d6 = MathUtil.sinToCos(d, d5);
        double d7 = Math.sin(d3);
        double d8 = MathUtil.sinToCos(d3, d7);
        return Math.acos(Math.min(1.0, d5 * d7 + d6 * d8 * Math.cos(Math.abs(d4 - d2))));
    }

    @Reference(authors="Sinnott, R. W.", title="Virtues of the Haversine", booktitle="Sky and telescope, 68-2, 1984")
    public static double haversineFormulaDeg(double d, double d2, double d3, double d4) {
        return SphereUtil.haversineFormulaRad(MathUtil.deg2rad(d), MathUtil.deg2rad(d2), MathUtil.deg2rad(d3), MathUtil.deg2rad(d4));
    }

    @Reference(authors="Sinnott, R. W.", title="Virtues of the Haversine", booktitle="Sky and telescope, 68-2, 1984")
    public static double haversineFormulaRad(double d, double d2, double d3, double d4) {
        double d5 = Math.sin((d - d3) * 0.5);
        double d6 = Math.sin((d2 - d4) * 0.5);
        double d7 = d5 * d5 + d6 * d6 * Math.cos(d) * Math.cos(d3);
        return 2.0 * Math.atan2(Math.sqrt(d7), Math.sqrt(1.0 - d7));
    }

    @Reference(authors="T. Vincenty", title="Direct and inverse solutions of geodesics on the ellipsoid with application of nested equations", booktitle="Survey review 23 176, 1975", url="http://www.ngs.noaa.gov/PUBS_LIB/inverse.pdf")
    public static double sphericalVincentyFormulaDeg(double d, double d2, double d3, double d4) {
        return SphereUtil.sphericalVincentyFormulaRad(MathUtil.deg2rad(d), MathUtil.deg2rad(d2), MathUtil.deg2rad(d3), MathUtil.deg2rad(d4));
    }

    @Reference(authors="T. Vincenty", title="Direct and inverse solutions of geodesics on the ellipsoid with application of nested equations", booktitle="Survey review 23 176, 1975", url="http://www.ngs.noaa.gov/PUBS_LIB/inverse.pdf")
    public static double sphericalVincentyFormulaRad(double d, double d2, double d3, double d4) {
        double d5 = Math.abs(d2 - d4);
        double d6 = Math.sin(d);
        double d7 = MathUtil.sinToCos(d, d6);
        double d8 = Math.sin(d3);
        double d9 = MathUtil.sinToCos(d3, d8);
        double d10 = Math.sin(d5);
        double d11 = MathUtil.sinToCos(d5, d10);
        double d12 = d9 * d10;
        double d13 = d7 * d8 - d6 * d9 * d11;
        return Math.atan2(Math.sqrt(d12 * d12 + d13 * d13), d6 * d8 + d7 * d9 * d11);
    }

    @Reference(authors="T. Vincenty", title="Direct and inverse solutions of geodesics on the ellipsoid with application of nested equations", booktitle="Survey review 23 176, 1975", url="http://www.ngs.noaa.gov/PUBS_LIB/inverse.pdf")
    public static double ellipsoidVincentyFormulaDeg(double d, double d2, double d3, double d4, double d5) {
        return SphereUtil.ellipsoidVincentyFormulaRad(d, MathUtil.deg2rad(d2), MathUtil.deg2rad(d3), MathUtil.deg2rad(d4), MathUtil.deg2rad(d5));
    }

    @Reference(authors="T. Vincenty", title="Direct and inverse solutions of geodesics on the ellipsoid with application of nested equations", booktitle="Survey review 23 176, 1975", url="http://www.ngs.noaa.gov/PUBS_LIB/inverse.pdf")
    public static double ellipsoidVincentyFormulaRad(double d, double d2, double d3, double d4, double d5) {
        double d6 = Math.abs(d5 - d3);
        double d7 = 1.0 - d;
        double d8 = 1.0 / d7;
        double d9 = (d8 + 1.0) * (d8 - 1.0);
        double d10 = Math.atan(d7 * Math.tan(d2));
        double d11 = Math.atan(d7 * Math.tan(d4));
        double d12 = Math.sin(d10);
        double d13 = MathUtil.sinToCos(d10, d12);
        double d14 = Math.sin(d11);
        double d15 = MathUtil.sinToCos(d11, d14);
        double d16 = d6;
        int n = 0;
        while (true) {
            double d17;
            double d18;
            double d19;
            double d20 = Math.sin(d16);
            double d21 = MathUtil.sinToCos(d16, d20);
            double d22 = d15 * d20;
            double d23 = d13 * d14 - d12 * d15 * d21;
            double d24 = Math.sqrt(d22 * d22 + d23 * d23);
            double d25 = d12 * d14 + d13 * d15 * d21;
            double d26 = Math.atan2(d24, d25);
            if (!(d24 > 0.0)) {
                return 0.0;
            }
            double d27 = d16;
            double d28 = d * 0.0625 * d19 * (4.0 + d * (4.0 - 3.0 * d19));
            double d29 = Math.abs(d19 = (1.0 + (d18 = d13 * d15 * d20 / d24)) * (1.0 - d18)) > 0.0 ? d25 - 2.0 * d12 * d14 / d19 : 0.0;
            if (Math.abs(d27 - (d16 = d6 + (1.0 - d28) * d * d18 * (d26 + d28 * d24 * (d29 + d28 * d25 * (-1.0 + 2.0 * (d17 = d29 * d29)))))) < 1.0E-12 || n >= 20) {
                double d30 = d19 * d9;
                double d31 = 1.0 + d30 / 16384.0 * (4096.0 + d30 * (-768.0 + d30 * (320.0 - 175.0 * d30)));
                double d32 = d30 / 1024.0 * (256.0 + d30 * (-128.0 + d30 * (74.0 - 47.0 * d30)));
                double d33 = d32 * d24 * (d29 + 0.25 * d32 * (d25 * (-1.0 + 2.0 * d17) - 0.16666666666666666 * d32 * d29 * (-3.0 + 4.0 * d24 * d24) * (-3.0 + 4.0 * d17)));
                return d31 * (d26 - d33);
            }
            ++n;
        }
    }

    public static double crossTrackDistanceDeg(double d, double d2, double d3, double d4, double d5, double d6) {
        return SphereUtil.crossTrackDistanceRad(MathUtil.deg2rad(d), MathUtil.deg2rad(d2), MathUtil.deg2rad(d3), MathUtil.deg2rad(d4), MathUtil.deg2rad(d5), MathUtil.deg2rad(d6));
    }

    public static double crossTrackDistanceRad(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d4 - d2;
        double d9 = d6 - d2;
        double d10 = Math.sin(d);
        double d11 = MathUtil.sinToCos(d, d10);
        double d12 = Math.sin(d5);
        double d13 = MathUtil.sinToCos(d5, d12);
        double d14 = Math.sin(d3);
        double d15 = MathUtil.sinToCos(d3, d14);
        double d16 = Math.sin(d8);
        double d17 = MathUtil.sinToCos(d8, d16);
        double d18 = Math.sin(d9);
        double d19 = MathUtil.sinToCos(d9, d18);
        double d20 = d16 * d15;
        double d21 = d18 * d13;
        double d22 = d11 * d14 - d10 * d15 * d17;
        double d23 = d11 * d12 - d10 * d13 * d19;
        double d24 = Math.atan2(d20, d22);
        double d25 = Math.atan2(d21, d23);
        return Math.asin(Math.sin(d7) * Math.sin(d25 - d24));
    }

    public static double crossTrackDistanceDeg(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return SphereUtil.crossTrackDistanceRad(MathUtil.deg2rad(d), MathUtil.deg2rad(d2), MathUtil.deg2rad(d3), MathUtil.deg2rad(d4), MathUtil.deg2rad(d5), MathUtil.deg2rad(d6), d7);
    }

    public static double crossTrackDistanceRad(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d4 - d2;
        double d8 = d6 - d2;
        double d9 = d5 - d;
        double d10 = Math.cos(d);
        double d11 = MathUtil.cosToSin(d, d10);
        double d12 = Math.cos(d5);
        double d13 = MathUtil.cosToSin(d5, d12);
        double d14 = Math.cos(d3);
        double d15 = MathUtil.cosToSin(d3, d14);
        double d16 = Math.sin(d9 * 0.5);
        double d17 = Math.sin(d8 * 0.5);
        double d18 = d16 * d16 + d17 * d17 * d10 * d12;
        double d19 = 2.0 * Math.atan2(Math.sqrt(d18), Math.sqrt(1.0 - d18));
        double d20 = Math.sin(d7);
        double d21 = MathUtil.sinToCos(d7, d20);
        double d22 = Math.sin(d8);
        double d23 = MathUtil.sinToCos(d8, d22);
        double d24 = d20 * d14;
        double d25 = d22 * d12;
        double d26 = d10 * d15 - d11 * d14 * d21;
        double d27 = d10 * d13 - d11 * d12 * d23;
        double d28 = Math.atan2(d24, d26);
        double d29 = Math.atan2(d25, d27);
        return Math.asin(Math.sin(d19) * Math.sin(d29 - d28));
    }

    public static double alongTrackDistanceDeg(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = SphereUtil.haversineFormulaDeg(d, d2, d5, d6);
        double d8 = SphereUtil.crossTrackDistanceDeg(d, d2, d3, d4, d5, d6, d7);
        return SphereUtil.alongTrackDistanceDeg(d, d2, d3, d4, d5, d6, d7, d8);
    }

    public static double alongTrackDistanceRad(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = SphereUtil.haversineFormulaRad(d, d2, d5, d6);
        double d8 = SphereUtil.crossTrackDistanceRad(d, d2, d3, d4, d5, d6, d7);
        return SphereUtil.alongTrackDistanceRad(d, d2, d3, d4, d5, d6, d7, d8);
    }

    public static double alongTrackDistanceDeg(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return SphereUtil.alongTrackDistanceRad(MathUtil.deg2rad(d), MathUtil.deg2rad(d2), MathUtil.deg2rad(d3), MathUtil.deg2rad(d4), MathUtil.deg2rad(d5), MathUtil.deg2rad(d6), d7, d8);
    }

    public static double alongTrackDistanceRad(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        int n = Math.abs(SphereUtil.bearingRad(d, d2, d3, d4) - SphereUtil.bearingRad(d, d2, d5, d6)) < 1.5707963267948966 ? 1 : -1;
        return (double)n * Math.acos(Math.cos(d7) / Math.cos(d8));
    }

    @Reference(authors="Erich Schubert, Arthur Zimek and Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Advances in Spatial and Temporal Databases - 13th International Symposium, SSTD 2013, Munich, Germany")
    public static double latlngMinDistDeg(double d, double d2, double d3, double d4, double d5, double d6) {
        return SphereUtil.latlngMinDistRad(MathUtil.deg2rad(d), MathUtil.deg2rad(d2), MathUtil.deg2rad(d3), MathUtil.deg2rad(d4), MathUtil.deg2rad(d5), MathUtil.deg2rad(d6));
    }

    @Reference(authors="Erich Schubert, Arthur Zimek and Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Advances in Spatial and Temporal Databases - 13th International Symposium, SSTD 2013, Munich, Germany")
    public static double latlngMinDistRad(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (d3 >= d5 && d4 >= d6) {
            return SphereUtil.haversineFormulaRad(d3, d4, d, d2);
        }
        if (d4 <= d2 && d2 <= d6) {
            if (d3 <= d && d <= d5) {
                return 0.0;
            }
            if (d < d3) {
                return d3 - d;
            }
            return d - d5;
        }
        double d8 = d4 - d2;
        if (d8 < 0.0) {
            d8 += Math.PI * 2;
        }
        if ((d7 = d6 - d2) > 0.0) {
            d7 -= Math.PI * 2;
        }
        if (d8 <= -d7) {
            double d9 = Math.cos(d8);
            double d10 = Math.tan(d);
            if (d8 > 1.5707963267948966) {
                double d11 = Math.tan((d5 + d3) * 0.5);
                if (d10 >= d11 * d9) {
                    return SphereUtil.haversineFormulaRad(d, d2, d5, d4);
                }
                return SphereUtil.haversineFormulaRad(d, d2, d3, d4);
            }
            double d12 = Math.tan(d5);
            if (d10 >= d12 * d9) {
                return SphereUtil.haversineFormulaRad(d, d2, d5, d4);
            }
            double d13 = Math.tan(d3);
            if (d10 <= d13 * d9) {
                return SphereUtil.haversineFormulaRad(d, d2, d3, d4);
            }
            double d14 = MathUtil.cosToSin(d8, d9);
            return Math.asin(Math.cos(d) * d14);
        }
        double d15 = Math.cos(d7);
        double d16 = Math.tan(d);
        if (-d7 > 1.5707963267948966) {
            double d17 = Math.tan((d5 + d3) * 0.5);
            if (d16 >= d17 * d15) {
                return SphereUtil.haversineFormulaRad(d, d2, d5, d6);
            }
            return SphereUtil.haversineFormulaRad(d, d2, d3, d6);
        }
        double d18 = Math.tan(d5);
        if (d16 >= d18 * d15) {
            return SphereUtil.haversineFormulaRad(d, d2, d5, d6);
        }
        double d19 = Math.tan(d3);
        if (d16 <= d19 * d15) {
            return SphereUtil.haversineFormulaRad(d, d2, d3, d6);
        }
        double d20 = MathUtil.cosToSin(d7, d15);
        return Math.asin(-Math.cos(d) * d20);
    }

    @Reference(authors="Erich Schubert, Arthur Zimek and Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Advances in Spatial and Temporal Databases - 13th International Symposium, SSTD 2013, Munich, Germany")
    public static double latlngMinDistRadFull(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (d3 >= d5 && d4 >= d6) {
            return SphereUtil.haversineFormulaRad(d3, d4, d, d2);
        }
        if (d4 <= d2 && d2 <= d6) {
            if (d3 <= d && d <= d5) {
                return 0.0;
            }
            if (d < d3) {
                return d3 - d;
            }
            return d - d5;
        }
        double d8 = d4 - d2;
        if (d8 < 0.0) {
            d8 += Math.PI * 2;
        }
        if ((d7 = d6 - d2) > 0.0) {
            d7 -= Math.PI * 2;
        }
        double d9 = Math.sin(d);
        double d10 = MathUtil.sinToCos(d, d9);
        double d11 = Math.sin(d5);
        double d12 = MathUtil.sinToCos(d5, d11);
        double d13 = Math.sin(d3);
        double d14 = MathUtil.sinToCos(d3, d13);
        if (d8 <= -d7) {
            double d15 = Math.sin(d8);
            double d16 = MathUtil.sinToCos(d8, d15);
            double d17 = Math.atan2(d15 * d10, d14 * d9 - d13 * d10 * d16);
            double d18 = Math.atan2(d15 * d10, d12 * d9 - d11 * d10 * d16);
            if (d17 < 1.5707963267948966 && d18 > 1.5707963267948966) {
                double d19 = -1.5707963267948966 - d;
                return Math.asin(Math.sin(d19) * -d15);
            }
            if (d17 - 1.5707963267948966 < 1.5707963267948966 - d18) {
                double d20 = Math.sin((d - d5) * 0.5);
                double d21 = Math.sin(d8 * 0.5);
                double d22 = d20 * d20 + d21 * d21 * d10 * d12;
                double d23 = 2.0 * Math.atan2(Math.sqrt(d22), Math.sqrt(1.0 - d22));
                return d23;
            }
            double d24 = Math.sin((d - d3) * 0.5);
            double d25 = Math.sin(d8 * 0.5);
            double d26 = d24 * d24 + d25 * d25 * d10 * d14;
            double d27 = 2.0 * Math.atan2(Math.sqrt(d26), Math.sqrt(1.0 - d26));
            return d27;
        }
        double d28 = Math.sin(d7);
        double d29 = MathUtil.sinToCos(d7, d28);
        double d30 = Math.atan2(d28 * d10, d14 * d9 - d13 * d10 * d29);
        double d31 = Math.atan2(d28 * d10, d12 * d9 - d11 * d10 * d29);
        if (d30 > -1.5707963267948966 && d31 < -1.5707963267948966) {
            double d32 = -1.5707963267948966 - d;
            return Math.asin(Math.sin(d32) * d28);
        }
        if (-1.5707963267948966 - d30 < d31 + 1.5707963267948966) {
            double d33 = Math.sin((d - d5) * 0.5);
            double d34 = Math.sin(d7 * 0.5);
            double d35 = d33 * d33 + d34 * d34 * d10 * d12;
            double d36 = 2.0 * Math.atan2(Math.sqrt(d35), Math.sqrt(1.0 - d35));
            return d36;
        }
        double d37 = Math.sin((d - d3) * 0.5);
        double d38 = Math.sin(d7 * 0.5);
        double d39 = d37 * d37 + d38 * d38 * d10 * d14;
        double d40 = 2.0 * Math.atan2(Math.sqrt(d39), Math.sqrt(1.0 - d39));
        return d40;
    }

    public static double bearingDegDeg(double d, double d2, double d3, double d4) {
        return MathUtil.rad2deg(SphereUtil.bearingRad(MathUtil.deg2rad(d), MathUtil.deg2rad(d2), MathUtil.deg2rad(d3), MathUtil.deg2rad(d4)));
    }

    public static double bearingRad(double d, double d2, double d3, double d4) {
        double d5 = Math.sin(d);
        double d6 = MathUtil.sinToCos(d, d5);
        double d7 = Math.sin(d3);
        double d8 = MathUtil.sinToCos(d3, d7);
        return Math.atan2(-Math.sin(d2 - d4) * d8, d6 * d7 - d5 * d8 * Math.cos(d2 - d4));
    }
}

