/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geometry;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

@Reference(authors="Paul Graham", title="An Efficient Algorithm for Determining the Convex Hull of a Finite Planar Set", booktitle="Information Processing Letters 1")
public class GrahamScanConvexHull2D {
    private List<Vector> points;
    private DoubleMinMax minmaxX = new DoubleMinMax();
    private DoubleMinMax minmaxY = new DoubleMinMax();
    private boolean ok = false;
    private double factor = 1.0;

    public GrahamScanConvexHull2D() {
        this.points = new LinkedList<Vector>();
    }

    public void add(Vector vector) {
        if (this.ok) {
            this.points = new LinkedList<Vector>(this.points);
            this.ok = false;
        }
        this.points.add(vector);
        this.minmaxX.put(vector.get(0));
        this.minmaxY.put(vector.get(1));
    }

    private void computeConvexHull() {
        if (this.points.size() < 3) {
            this.ok = true;
            return;
        }
        double d = Math.max(Math.abs(this.minmaxX.getMin()), Math.abs(this.minmaxX.getMax()));
        double d2 = Math.max(Math.abs(this.minmaxY.getMin()), Math.abs(this.minmaxY.getMax()));
        if (d < 10.0 || d2 < 10.0) {
            this.factor = 10.0 / d;
            if (10.0 / d2 > this.factor) {
                this.factor = 10.0 / d2;
            }
        }
        this.findStartingPoint();
        final Vector vector = this.points.get(0);
        Collections.sort(this.points, new Comparator<Vector>(){

            @Override
            public int compare(Vector vector3, Vector vector2) {
                return GrahamScanConvexHull2D.this.isLeft(vector3, vector2, vector);
            }
        });
        this.grahamScan();
        this.ok = true;
    }

    private void findStartingPoint() {
        double d = this.minmaxY.getMin();
        double d2 = Double.POSITIVE_INFINITY;
        int n = -1;
        Iterator<Vector> iterator = this.points.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Vector vector = iterator.next();
            if (vector.get(1) == d && vector.get(0) < d2) {
                d2 = vector.get(0);
                n = n2;
            }
            ++n2;
        }
        assert (n >= 0);
        if (n > 0) {
            this.points.add(0, this.points.remove(n));
        }
    }

    private final double getRX(Vector vector, Vector vector2) {
        return (vector.get(0) - vector2.get(0)) * this.factor;
    }

    private final double getRY(Vector vector, Vector vector2) {
        return (vector.get(1) - vector2.get(1)) * this.factor;
    }

    protected final int isLeft(Vector vector, Vector vector2, Vector vector3) {
        double d = this.getRX(vector, vector3) * this.getRY(vector2, vector3) - this.getRY(vector, vector3) * this.getRX(vector2, vector3);
        if (d == 0.0) {
            double d2 = Math.abs(this.getRX(vector, vector3)) + Math.abs(this.getRY(vector, vector3));
            double d3 = Math.abs(this.getRX(vector2, vector3)) + Math.abs(this.getRY(vector2, vector3));
            return Double.compare(d2, d3);
        }
        return Double.compare(d, 0.0);
    }

    private double mdist(Vector vector, Vector vector2) {
        return Math.abs(vector.get(0) * this.factor - vector2.get(0) * this.factor) + Math.abs(vector.get(1) * this.factor - vector2.get(1) * this.factor);
    }

    private final boolean isConvex(Vector vector, Vector vector2, Vector vector3) {
        double d = (vector2.get(0) * this.factor - vector.get(0) * this.factor) * (vector3.get(1) * this.factor - vector.get(1) * this.factor) - (vector3.get(0) * this.factor - vector.get(0) * this.factor) * (vector2.get(1) * this.factor - vector.get(1) * this.factor);
        if (d == 0.0) {
            return this.mdist(vector2, vector3) >= this.mdist(vector, vector2) + this.mdist(vector, vector3);
        }
        return d < 0.0;
    }

    private void grahamScan() {
        if (this.points.size() < 3) {
            return;
        }
        Iterator<Vector> iterator = this.points.iterator();
        Stack<Vector> stack = new Stack<Vector>();
        stack.add(iterator.next());
        stack.add(iterator.next());
        while (iterator.hasNext()) {
            Vector vector = iterator.next();
            Vector vector2 = stack.pop();
            Vector vector3 = stack.peek();
            while (stack.size() > 1 && !this.isConvex(vector3, vector2, vector)) {
                vector2 = stack.pop();
                vector3 = stack.peek();
            }
            stack.add(vector2);
            stack.add(vector);
        }
        this.points = stack;
    }

    public Polygon getHull() {
        if (!this.ok) {
            this.computeConvexHull();
        }
        return new Polygon(this.points, this.minmaxX.getMin(), this.minmaxX.getMax(), this.minmaxY.getMin(), this.minmaxY.getMax());
    }
}

