/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.WeakEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.ArrayList;

@Title(value="Drop EigenPair Filter")
public class DropEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_WALPHA = 0.0;
    private double walpha = 0.0;

    public DropEigenPairFilter(double d) {
        this.walpha = d;
    }

    @Override
    public FilteredEigenPairs filter(SortedEigenPairs sortedEigenPairs) {
        int n;
        ArrayList<EigenPair> arrayList = new ArrayList<EigenPair>();
        ArrayList<EigenPair> arrayList2 = new ArrayList<EigenPair>();
        int n2 = sortedEigenPairs.size() - 1;
        double d = 0.0;
        double[] dArray = sortedEigenPairs.eigenValues();
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i];
        }
        double d3 = this.walpha * d2 / (double)dArray.length;
        double d4 = dArray[dArray.length - 1];
        double d5 = 1.0;
        for (n = 2; n <= dArray.length; ++n) {
            double d6;
            double d7 = d4 + dArray[dArray.length - n];
            double d8 = dArray[dArray.length - n] / d7 * (double)n;
            if (dArray[dArray.length - n] >= d3 && (d6 = d8 - d5) > d) {
                d = d6;
                n2 = dArray.length - n;
            }
            d4 = d7;
            d5 = d8;
        }
        for (n = 0; n <= n2; ++n) {
            EigenPair eigenPair = sortedEigenPairs.getEigenPair(n);
            arrayList.add(eigenPair);
        }
        for (n = n2 + 1; n < sortedEigenPairs.size(); ++n) {
            EigenPair eigenPair = sortedEigenPairs.getEigenPair(n);
            arrayList2.add(eigenPair);
        }
        return new FilteredEigenPairs(arrayList2, arrayList);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private double walpha;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(WeakEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_WALPHA, 0.0);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.walpha = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected DropEigenPairFilter makeInstance() {
            return new DropEigenPairFilter(this.walpha);
        }
    }
}

