/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.dependence.DependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerComparator;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDependenceMeasure
implements DependenceMeasure {
    @Override
    public abstract <A, B> double dependence(NumberArrayAdapter<?, A> var1, A var2, NumberArrayAdapter<?, B> var3, B var4);

    @Override
    public double dependence(double[] dArray, double[] dArray2) {
        return this.dependence(ArrayLikeUtil.DOUBLEARRAYADAPTER, dArray, ArrayLikeUtil.DOUBLEARRAYADAPTER, dArray2);
    }

    @Override
    public <A> double dependence(NumberArrayAdapter<?, A> numberArrayAdapter, A a, A a2) {
        return this.dependence(numberArrayAdapter, a, numberArrayAdapter, a2);
    }

    @Override
    public <A> double[] dependence(NumberArrayAdapter<?, A> numberArrayAdapter, List<? extends A> list) {
        int n = list.size();
        double[] dArray = new double[n * (n - 1) >> 1];
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            A a = list.get(i);
            for (int j = 0; j < i; ++j) {
                dArray[n2++] = this.dependence(numberArrayAdapter, list.get(j), numberArrayAdapter, a);
            }
        }
        return dArray;
    }

    protected static double clamp(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    public static <A> double[] computeNormalizedRanks(NumberArrayAdapter<?, A> numberArrayAdapter, A a, int n) {
        int[] nArray = AbstractDependenceMeasure.sortedIndex(numberArrayAdapter, a, n);
        double d = 0.5 / (double)(n - 1);
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            double d2 = numberArrayAdapter.getDouble(a, nArray[n3]);
            while (n2 < n && numberArrayAdapter.getDouble(a, nArray[n2]) <= d2) {
                ++n2;
            }
            double d3 = (double)(n3 + n2 - 1) * d;
            for (int i = n3; i < n2; ++i) {
                dArray[nArray[i]] = d3;
            }
        }
        return dArray;
    }

    public static <A> double[] ranks(NumberArrayAdapter<?, A> numberArrayAdapter, A a, int n) {
        int[] nArray = AbstractDependenceMeasure.sortedIndex(numberArrayAdapter, a, n);
        return AbstractDependenceMeasure.ranks(numberArrayAdapter, a, nArray);
    }

    public static <A> double[] ranks(NumberArrayAdapter<?, A> numberArrayAdapter, A a, int[] nArray) {
        int n = nArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            double d = numberArrayAdapter.getDouble(a, nArray[n3]);
            while (n2 < n && numberArrayAdapter.getDouble(a, nArray[n2]) <= d) {
                ++n2;
            }
            double d2 = (double)(n3 + n2 - 1) * 0.5 + 1.0;
            for (int i = n3; i < n2; ++i) {
                dArray[nArray[i]] = d2;
            }
        }
        return dArray;
    }

    public static <A> int[] sortedIndex(final NumberArrayAdapter<?, A> numberArrayAdapter, final A a, int n) {
        int[] nArray = MathUtil.sequence(0, n);
        IntegerArrayQuickSort.sort(nArray, new IntegerComparator(){

            @Override
            public int compare(int n, int n2) {
                return Double.compare(numberArrayAdapter.getDouble(a, n), numberArrayAdapter.getDouble(a, n2));
            }
        });
        return nArray;
    }

    public static <A> int[] discretize(NumberArrayAdapter<?, A> numberArrayAdapter, A a, int n, int n2) {
        double d;
        double d2 = d = numberArrayAdapter.getDouble(a, 0);
        for (int i = 1; i < n; ++i) {
            double d3 = numberArrayAdapter.getDouble(a, i);
            if (d3 < d) {
                d = d3;
                continue;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        double d4 = d2 > d ? (double)n2 / (d2 - d) : 1.0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n3 = (int)Math.floor((numberArrayAdapter.getDouble(a, i) - d) * d4);
            nArray[i] = n3 < 0 ? 0 : (n3 >= n2 ? n2 - 1 : n3);
        }
        return nArray;
    }

    protected static int index(int n, int n2) {
        assert (n < n2) : "Only lower triangle is allowed.";
        return (n2 * (n2 - 1) >> 1) + n;
    }

    public static <A, B> int size(NumberArrayAdapter<?, A> numberArrayAdapter, A a, NumberArrayAdapter<?, B> numberArrayAdapter2, B b) {
        int n = numberArrayAdapter.size(a);
        if (n != numberArrayAdapter2.size(b)) {
            throw new AbortException("Array sizes do not match!");
        }
        if (n == 0) {
            throw new AbortException("Empty array!");
        }
        return n;
    }

    public static <A> int size(NumberArrayAdapter<?, A> numberArrayAdapter, Collection<? extends A> collection) {
        if (collection.size() < 2) {
            throw new AbortException("Need at least two axes to compute dependence measures.");
        }
        Iterator<A> iterator = collection.iterator();
        int n = numberArrayAdapter.size(iterator.next());
        while (iterator.hasNext()) {
            if (n == numberArrayAdapter.size(iterator.next())) continue;
            throw new AbortException("Array sizes do not match!");
        }
        if (n == 0) {
            throw new AbortException("Empty array!");
        }
        return n;
    }
}

