/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.AbstractDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.List;

@Reference(authors="Sz\u00e9kely, G. J., Rizzo, M. L., & Bakirov, N. K.", title="Measuring and testing dependence by correlation of distances", booktitle="The Annals of Statistics, 35(6), 2769-2794", url="http://dx.doi.org/10.1214/009053607000000505")
public class DistanceCorrelationDependenceMeasure
extends AbstractDependenceMeasure {
    public static final DistanceCorrelationDependenceMeasure STATIC = new DistanceCorrelationDependenceMeasure();

    protected DistanceCorrelationDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> numberArrayAdapter, A a, NumberArrayAdapter<?, B> numberArrayAdapter2, B b) {
        int n = DistanceCorrelationDependenceMeasure.size(numberArrayAdapter, a, numberArrayAdapter2, b);
        double[] dArray = DistanceCorrelationDependenceMeasure.computeDistances(numberArrayAdapter, a);
        double[] dArray2 = DistanceCorrelationDependenceMeasure.computeDistances(numberArrayAdapter2, b);
        double d = this.computeDCovar(dArray, dArray, n);
        if (!(d > 0.0)) {
            return 0.0;
        }
        double d2 = this.computeDCovar(dArray2, dArray2, n);
        if (!(d2 > 0.0)) {
            return 0.0;
        }
        double d3 = this.computeDCovar(dArray, dArray2, n);
        return Math.sqrt(d3 / Math.sqrt(d * d2));
    }

    @Override
    public <A> double[] dependence(NumberArrayAdapter<?, A> numberArrayAdapter, List<? extends A> list) {
        int n = list.size();
        int n2 = DistanceCorrelationDependenceMeasure.size(numberArrayAdapter, list);
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = DistanceCorrelationDependenceMeasure.computeDistances(numberArrayAdapter, list.get(i));
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.computeDCovar(dArrayArray[i], dArrayArray[i], n2);
        }
        double[] dArray2 = new double[n * (n - 1) >> 1];
        int n3 = 0;
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!(dArray[j] * dArray[i] > 0.0)) {
                    dArray2[n3++] = 0.0;
                    continue;
                }
                double d = this.computeDCovar(dArrayArray[j], dArrayArray[i], n2);
                dArray2[n3++] = Math.sqrt(d / Math.sqrt(dArray[j] * dArray[i]));
            }
        }
        return dArray2;
    }

    protected static <A> double[] computeDistances(NumberArrayAdapter<?, A> numberArrayAdapter, A a) {
        int n = numberArrayAdapter.size(a);
        double[] dArray = new double[n * (n + 1) >> 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double d = numberArrayAdapter.getDouble(a, i) - numberArrayAdapter.getDouble(a, j);
                dArray[n2++] = d < 0.0 ? -d : d;
            }
            ++n2;
        }
        DistanceCorrelationDependenceMeasure.doubleCenterMatrix(dArray, n);
        return dArray;
    }

    public static void doubleCenterMatrix(double[] dArray, int n) {
        int n2;
        double[] dArray2 = new double[n];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = 0;
            while (n2 < i) {
                double d = dArray[n3++];
                int n4 = i;
                dArray2[n4] = dArray2[n4] + d;
                int n5 = n2++;
                dArray2[n5] = dArray2[n5] + d;
            }
            assert (dArray[n3] == 0.0);
            ++n3;
        }
        double d = 0.0;
        n2 = 0;
        while (n2 < n) {
            d += dArray2[n2];
            int n6 = n2++;
            dArray2[n6] = dArray2[n6] / (double)n;
        }
        d /= (double)(n * n);
        int n7 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i <= n2; ++i) {
                int n8 = n7++;
                dArray[n8] = dArray[n8] - (dArray2[n2] + dArray2[i] - d);
            }
        }
    }

    protected double computeDCovar(double[] dArray, double[] dArray2, int n) {
        double d = 0.0;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                d += 2.0 * dArray[n2] * dArray2[n2];
                ++n2;
            }
            d += dArray[n2] * dArray2[n2];
            ++n2;
        }
        return d / (double)(n * n);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected DistanceCorrelationDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

