/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class GumbelDistribution
extends AbstractDistribution {
    double mu;
    double beta;

    public GumbelDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    public GumbelDistribution(double d, double d2, Random random) {
        super(random);
        this.mu = d;
        this.beta = d2;
    }

    public GumbelDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        this.mu = d;
        this.beta = d2;
    }

    public static double pdf(double d, double d2, double d3) {
        double d4 = (d - d2) / d3;
        return Math.exp(-d4 - Math.exp(-d4)) / d3;
    }

    @Override
    public double pdf(double d) {
        return GumbelDistribution.pdf(d, this.mu, this.beta);
    }

    public static double cdf(double d, double d2, double d3) {
        return Math.exp(-Math.exp(-(d - d2) / d3));
    }

    @Override
    public double cdf(double d) {
        return GumbelDistribution.cdf(d, this.mu, this.beta);
    }

    public static double quantile(double d, double d2, double d3) {
        return d2 + d3 * Math.log(1.0 / Math.log(1.0 / d));
    }

    @Override
    public double quantile(double d) {
        return GumbelDistribution.quantile(d, this.mu, this.beta);
    }

    @Override
    public double nextRandom() {
        return this.mu + this.beta * Math.log(1.0 / Math.log(1.0 / this.random.nextDouble()));
    }

    @Override
    public String toString() {
        return "GumbelDistribution(mu=" + this.mu + ", beta=" + this.beta + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mean;
        double shape;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.mean = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHAPE_ID))) {
                this.shape = doubleParameter.doubleValue();
            }
        }

        @Override
        protected GumbelDistribution makeInstance() {
            return new GumbelDistribution(this.mean, this.shape, this.rnd);
        }
    }
}

