/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LaplaceDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class LaplaceLMMEstimator
extends AbstractLMMEstimator<LaplaceDistribution> {
    public static final LaplaceLMMEstimator STATIC = new LaplaceLMMEstimator();

    private LaplaceLMMEstimator() {
    }

    @Override
    public LaplaceDistribution estimateFromLMoments(double[] dArray) {
        double d = dArray[0];
        double d2 = 1.3333333333333333 * dArray[1];
        return new LaplaceDistribution(1.0 / d2, d);
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public Class<? super LaplaceDistribution> getDistributionClass() {
        return LaplaceDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LaplaceLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

