/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LaplaceDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="Applied Robust Statistics", authors="D. J. Olive", booktitle="Applied Robust Statistics", url="http://lagrange.math.siu.edu/Olive/preprints.htm")
public class LaplaceMADEstimator
extends AbstractMADEstimator<LaplaceDistribution> {
    public static final LaplaceMADEstimator STATIC = new LaplaceMADEstimator();

    private LaplaceMADEstimator() {
    }

    @Override
    public LaplaceDistribution estimateFromMedianMAD(double d, double d2) {
        double d3 = d;
        double d4 = 1.443 * d2;
        return new LaplaceDistribution(1.0 / d4, d3);
    }

    @Override
    public Class<? super LaplaceDistribution> getDistributionClass() {
        return LaplaceDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LaplaceMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

