/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogNormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="D. B\u00edlkov\u00e1", title="Lognormal distribution and using L-moment method for estimating its parameters", booktitle="Int. Journal of Mathematical Models and Methods in Applied Sciences (NAUN)", url="http://www.naun.org/multimedia/NAUN/m3as/17-079.pdf")
public class LogNormalBilkovaLMMEstimator
extends AbstractLMMEstimator<LogNormalDistribution> {
    public static final LogNormalBilkovaLMMEstimator STATIC = new LogNormalBilkovaLMMEstimator();
    private static final double SQRT8_3 = Math.sqrt(2.6666666666666665);

    private LogNormalBilkovaLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public LogNormalDistribution estimateFromLMoments(double[] dArray) {
        if (!(dArray[1] > 0.0 && Math.abs(dArray[2]) < 1.0 && dArray[2] > 0.0)) {
            throw new ArithmeticException("L-Moments invalid");
        }
        double d = SQRT8_3 * NormalDistribution.standardNormalQuantile(0.5 * (1.0 + dArray[2]));
        double d2 = d * d;
        double d3 = 0.999281 * d - 0.006118 * d * d2 + 1.27E-4 * d * d2 * d2;
        double d4 = d3 * d3 * 0.5;
        double d5 = Math.log(dArray[1] / NormalDistribution.erf(0.5 * d3)) - d4;
        return new LogNormalDistribution(d5, Math.max(d3, Double.MIN_NORMAL), dArray[0] - Math.exp(d5 + d4));
    }

    @Override
    public Class<? super LogNormalDistribution> getDistributionClass() {
        return LogNormalDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogNormalBilkovaLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

